/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.tickpolicy;

import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseRideTickEvent;
import com.equestricraft.mod.horse.tickpolicy.HorseServerTickPolicy;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class StandardHorseServerTickPolicy
extends HorseServerTickPolicy {
    @Override
    public void onTick(EntityHorse horse) {
        EQHorse data = horse.getHorseData();
        if (data != null) {
            data.activeTick();
            Optional<ECPlayer> ridingPlayer = data.getCurrentRide().getPlayer();
            if (ridingPlayer.isPresent()) {
                OnlinePlayer onlinePlayer = ridingPlayer.get().require(OnlinePlayer.class);
                HorseSubGait gait = horse.m_20184_().equals((Object)Vec3.f_82478_) ? Halt.DEFAULT : horse.getGait();
                HorseRideTickEvent event = new HorseRideTickEvent(data, gait, onlinePlayer);
                MinecraftForge.EVENT_BUS.post((Event)event);
                int percentage = (int)data.getStamina().getPercentage();
                long value = data.getStamina().getPoints();
                onlinePlayer.getDisplay().getHorseStamina().showStaminaInformation(percentage, value < event.getGait().getMinimumStamina());
            }
        }
    }
}

