/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.token;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.token.NotEnoughTokensException;
import com.equestricraft.mod.horse.token.HorseTokenService;
import java.util.UUID;

public class HorseTokenServiceImpl
implements HorseTokenService {
    @Service
    private PlayerService playerService;

    @Override
    public Response depositHorseCreateTokens(UUID uuid, int amount) {
        CorePlayer player = this.playerService.retrievePlayerByAccountUuid(uuid);
        return this.depositHorseCreateTokens(player, amount);
    }

    @Override
    public Response depositHorseCreateTokens(String ign, int amount) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        return this.depositHorseCreateTokens(player, amount);
    }

    @Override
    public Response withdrawHorseCreateTokens(UUID uuid, int amount) {
        CorePlayer player = this.playerService.retrievePlayerByAccountUuid(uuid);
        return this.withdrawHorseCreateTokens(player, amount);
    }

    @Override
    public Response withdrawHorseCreateTokens(String ign, int amount) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        return this.withdrawHorseCreateTokens(player, amount);
    }

    private Response depositHorseCreateTokens(CorePlayer player, int amount) {
        player.getTokens().giveHorseCreateTokens(amount);
        return ResponseFactory.success(I18n.getLabel("horse.tokens.create.deposited", amount, player.getIgn(), player.getTokens().getHorseCreateTokenCount()));
    }

    private Response withdrawHorseCreateTokens(CorePlayer player, int amount) {
        try {
            player.getTokens().takeHorseCreateTokens(amount);
            return ResponseFactory.success(I18n.getLabel("horse.tokens.create.withdrawn", amount, player.getIgn(), player.getTokens().getHorseCreateTokenCount()));
        }
        catch (NotEnoughTokensException ex) {
            return ResponseFactory.fail(ex);
        }
    }
}

