/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.travelpolicy;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.EnvironmentType;
import com.equestricraft.common.TrustAction;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.spook.SpookTrait;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.horse.collision.HorseCollisionEvent;
import com.equestricraft.mod.horse.travelpolicy.HorseTravelPolicy;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.time.Duration;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class StandardHorseTravelPolicy
extends HorseTravelPolicy {
    @Override
    public void travel(EntityHorse horse, Vec3 vec) {
        EQHorse horseData = horse.getHorseData();
        if (horseData != null) {
            this.checkAndRecordMovement(horse, horseData);
            this.checkAndUpdateEnvironment(horse, horseData);
            this.checkForCollision(horse);
            this.checkForStaminaDrain(horse, horseData);
        }
    }

    private void checkAndRecordMovement(EntityHorse horse, EQHorse horseData) {
        Vec3 position = horse.m_20182_();
        ECLevel level = ServerLevelUtil.getEntitiesECLevel((Entity)horse);
        Coordinate coordinate = new Coordinate(position.m_7096_(), position.m_7098_(), position.m_7094_(), level.getIdentifier());
        horseData.getMovement().addMovementCoordinate(coordinate);
    }

    private void checkAndUpdateEnvironment(EntityHorse horse, EQHorse horseData) {
        EnvironmentType type = horse.getCurrentEnvironment();
        horseData.getEnvironment().setCurrentEnvironment(type);
    }

    private void checkForCollision(EntityHorse horse) {
        EntityHorse t;
        if (horse.m_20160_() && (t = (EntityHorse)horse.m_183503_().m_45963_(EntityHorse.class, TargetingConditions.m_148353_(), (LivingEntity)horse, 1.0, 1.0, 1.0, new AABB(horse.m_142538_()))) != null) {
            TaskScheduler.executeAsyncTask(() -> this.handleCollision(horse));
        }
    }

    private void handleCollision(EntityHorse horse) {
        MinecraftForge.EVENT_BUS.post((Event)new HorseCollisionEvent(horse));
        EQHorse h = horse.getHorseData();
        Optional<ECPlayer> rider = h.getCurrentRide().getPlayer();
        if (rider.isPresent()) {
            h.getTrust().processAction(rider.get(), TrustAction.COLLISION_SET_UP);
            horse.negativeRideEnd(I18n.getLabel("horse.eject.collision"));
            if (h.getTraits().getValue(SpookTrait.class) > 0.5f) {
                horse.setPanic(Duration.ofSeconds(10L));
            }
        }
    }

    private void checkForStaminaDrain(EntityHorse horse, EQHorse horseData) {
        if (horseData.getCurrentRide().hasCurrentRide()) {
            return;
        }
        HorseSubGait gait = horse.getGait();
        long stamina = horseData.getStamina().getPoints();
        if (stamina < gait.getMinimumStamina()) {
            HorseSubGait highestGait = horseData.getGait().getHighestAvailable();
            horse.setGait(highestGait);
        }
    }
}

