/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.horse.weight;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.HorseSimple;
import com.equestricraft.core.horse.HorseTransformer;
import com.equestricraft.core.horse.weight.HorseWeightLogPaginationSession;
import com.equestricraft.core.horse.weight.HorseWeightPage;
import com.equestricraft.mod.horse.weight.HorseWeightLogService;
import com.equestricraft.mod.packet.ClientBoundHorseWeightLogOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;

public class HorseWeightLogServiceImpl
implements HorseWeightLogService {
    @Service
    private HorseWeightLogPaginationSession horseWeightLogPaginationSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseTransformer horseTransformer;

    @Override
    public Response showHorseWeightLogPage(OnlinePlayer player, int horseId, int pageNumber, SortDirection sortDirection) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        return this.showHorseWeightLogPage(player, horse, pageNumber, sortDirection);
    }

    @Override
    public Response showHorseWeightLogPage(OnlinePlayer player, EQHorse horse, int pageNumber, SortDirection sortDirection) {
        HorseWeightPage page = this.horseWeightLogPaginationSession.retrieveHorseWeightLogPage(horse.getId(), pageNumber, sortDirection);
        HorseSimple simple = this.horseTransformer.toSimple(horse);
        ClientBoundHorseWeightLogOpenPacket packet = new ClientBoundHorseWeightLogOpenPacket(simple, page);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }
}

