/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.i18n;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.i18n.I18nDto;
import com.equestricraft.mod.i18n.I18nNetworkService;
import com.equestricraft.mod.i18n.I18nPrefixDto;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ClientBoundI18nDataPacket;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;

public class I18nNetworkServiceImpl
implements I18nNetworkService {
    @Override
    public void sendI18nDataToPlayer(ServerPlayer player) {
        ClientBoundI18nDataPacket packet = this.buildI18nDataPacket();
        Network.sendToPlayer(player, packet);
    }

    @Override
    public void sendI18nDataToAll() {
        ClientBoundI18nDataPacket packet = this.buildI18nDataPacket();
        Network.sendToAll(packet);
    }

    private ClientBoundI18nDataPacket buildI18nDataPacket() {
        List<I18nDto> resourcesList = this.retrieveAllI18nData();
        List<I18nPrefixDto> prefixesList = this.retrieveAllI18nPrefixData();
        return new ClientBoundI18nDataPacket(resourcesList, prefixesList);
    }

    private List<I18nDto> retrieveAllI18nData() {
        Map<String, String> resourcesMap = I18n.getI18n().getResourceMap();
        return this.transformResourcesMapToI18nDtoList(resourcesMap);
    }

    private List<I18nDto> transformResourcesMapToI18nDtoList(Map<String, String> resources) {
        return resources.entrySet().stream().map(me -> new I18nDto((String)me.getKey(), (String)me.getValue())).toList();
    }

    private List<I18nPrefixDto> retrieveAllI18nPrefixData() {
        Map<String, String> prefixesMap = I18n.getI18n().getPrefixMap();
        return this.transformPrefixMapToI18nPrefixDtoList(prefixesMap);
    }

    private List<I18nPrefixDto> transformPrefixMapToI18nPrefixDtoList(Map<String, String> prefixes) {
        return prefixes.entrySet().stream().map(me -> new I18nPrefixDto((String)me.getKey(), (String)me.getValue())).toList();
    }
}

