/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.ipcheck;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.utilities.BroadcastMessageHelper;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class IPCheckListener {
    @Service
    private static PlayerRepository playerRepository;

    @SubscribeEvent
    public static void checkIpOnJoin(ECPlayerJoinEvent event) {
        String ipAddress = event.getPlayer().getCorePlayer().getIpAddress();
        List<CorePlayer> playersWithIpAddress = playerRepository.findPlayersWithIpAddress(ipAddress);
        if (playersWithIpAddress.size() > 1) {
            String message = IPCheckListener.buildMessage(ipAddress, playersWithIpAddress);
            BroadcastMessageHelper.broadcastMessageWithPermission(message, "equestricraft.ip-check");
        }
    }

    private static String buildMessage(String ipAddress, List<CorePlayer> players) {
        StringBuilder stringBuilder = new StringBuilder("IP Check\n");
        stringBuilder.append("IP Address").append(ipAddress).append("\n");
        for (CorePlayer player : players) {
            stringBuilder.append(" - ").append(player.getIgn());
            if (player.isOnline()) {
                stringBuilder.append(" (Online)");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private IPCheckListener() {
    }
}

