/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.command.argproviders.OnlinePlayersArgumentSuggestionProvider;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.job.JobArgumentProvider;
import com.equestricraft.mod.job.JobService;
import com.equestricraft.mod.player.OnlinePlayer;

@Command(value="job-admin")
public class JobAdminCommand {
    @Service
    private JobService jobService;

    @Async
    @Command(value="promote")
    public Response promotePlayerToJob(@Arg(suggestionProvider=JobArgumentProvider.class) String jobIdentifier, @Arg(suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobService.promotePlayer(player, jobIdentifier, playerIgn);
    }

    @Async
    @Command(value="demote")
    public Response demotePlayerFromJob(@Arg(suggestionProvider=JobArgumentProvider.class) String jobIdentifier, @Arg(suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobService.demotePlayer(player, jobIdentifier, playerIgn);
    }

    @Async
    @Command(value="promote-manager")
    @Permission(value="equestricraft.job")
    public Response promotePlayerToJobManager(@Arg(suggestionProvider=JobArgumentProvider.class) String jobIdentifier, @Arg(suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobService.promotePlayerManager(player, jobIdentifier, playerIgn);
    }

    @Async
    @Command(value="demote-manager")
    @Permission(value="equestricraft.job")
    public Response demotePlayerFromJobManager(@Arg(suggestionProvider=JobArgumentProvider.class) String jobIdentifier, @Arg(suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobService.demotePlayerManager(player, jobIdentifier, playerIgn);
    }

    @Async
    @Command(value="induction-complete")
    public Response setPlayerFinishedJobInduction(@Arg(suggestionProvider=JobArgumentProvider.class) String jobIdentifier, @Arg(suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn) {
        return this.jobService.setPlayerFinishedInduction(jobIdentifier, playerIgn);
    }
}

