/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.job.work.JobActiveWorkException;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.job.activework.JobActiveWorkService;
import com.equestricraft.mod.job.requests.JobRequestService;
import com.equestricraft.mod.player.OnlinePlayer;

@Command(value="job")
public class JobCommand {
    @Service
    private JobActiveWorkService jobActiveWorkService;
    @Service
    private JobRequestService jobRequestService;

    @Command(value="start")
    @Async
    public Response onStart() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobActiveWorkService.showJobActiveWorkStartMenu(player);
    }

    @Command(value="complete")
    @Async
    public Response completeWork() throws JobActiveWorkException {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobActiveWorkService.completeWork(player);
    }

    @Command(value="cancel")
    @Async
    public Response cancelWork() throws JobActiveWorkException {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobActiveWorkService.cancelWork(player);
    }

    @Command(value="invoices")
    @Async
    public void invoices() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        this.jobActiveWorkService.showPlayersDueInvoices(player, 1);
    }

    @Command(value="requests")
    @Async
    public Response requests() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.jobRequestService.showJobRequestMenuToPlayer(player);
    }

    @Command(value="assigned")
    @Async
    public void assigned() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        this.jobRequestService.showAssignedRequestsMenuToPlayer(player);
    }
}

