/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.JobMemberDto;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.job.JobMemberInfo;
import com.equestricraft.mod.job.JobMemberScreenPageService;
import com.equestricraft.mod.job.JobScreenPage;
import java.util.Comparator;
import java.util.List;

public class JobMemberScreenPageServiceImpl
extends Pagination<JobMemberInfo, JobScreenPage, Object, Object>
implements JobMemberScreenPageService {
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public JobScreenPage retrievePage(List<JobMemberDto> jobMembers, int pageNumber) {
        List<JobMemberInfo> items = jobMembers.stream().map(this::buildJobMemberScreenItem).toList();
        return (JobScreenPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    private JobMemberInfo buildJobMemberScreenItem(JobMemberDto member) {
        return new JobMemberInfo(member.player(), this.buildPosition(member), this.onlinePlayerCache.isPlayerOnline(member.player().id()));
    }

    private String buildPosition(JobMemberDto member) {
        if (member.manager()) {
            return I18n.getLabel("job.member-menu.head");
        }
        if (!member.finishedInduction()) {
            return I18n.getLabel("job.member-menu.not-finished-induction");
        }
        return member.rankName();
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(JobMemberInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<JobMemberInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(JobMemberInfo::online).thenComparing(i -> i.player().ign());
    }

    @Override
    protected JobScreenPage buildPage(List<JobMemberInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new JobScreenPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

