/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobMemberDto;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSession;
import com.equestricraft.mod.job.JobMemberScreenPageService;
import com.equestricraft.mod.job.JobMembersScreenService;
import com.equestricraft.mod.job.JobScreenPage;
import com.equestricraft.mod.packet.ClientBoundJobMembersListOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class JobMembersScreenServiceImpl
implements JobMembersScreenService {
    @Service
    private JobSession jobSession;
    @Service
    private JobRepository jobRepository;
    @Service
    private JobMemberScreenPageService jobMemberScreenPageService;

    @Override
    public Response showJobMembersMenu(OnlinePlayer onlinePlayer, String jobIdentifier) {
        Job job = this.jobSession.retrieveJobByIdentifier(jobIdentifier);
        return this.showJobMembersMenu(onlinePlayer, job, 1);
    }

    @Override
    public Response showJobMembersMenu(OnlinePlayer onlinePlayer, int jobId, int pageNumber) {
        Job job = (Job)this.jobRepository.findByKey(jobId);
        return this.showJobMembersMenu(onlinePlayer, job, pageNumber);
    }

    private Response showJobMembersMenu(OnlinePlayer onlinePlayer, Job job, int pageNumber) {
        List<JobMemberDto> members = this.jobSession.retrieveJobMembers(job.getId());
        JobScreenPage jobScreenPage = this.jobMemberScreenPageService.retrievePage(members, pageNumber);
        ClientBoundJobMembersListOpenPacket packet = new ClientBoundJobMembersListOpenPacket(job.getId(), job.getName(), jobScreenPage);
        onlinePlayer.sendPacket(packet);
        return ResponseFactory.success();
    }
}

