/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobInfo;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.job.PlayerJobSession;
import com.equestricraft.core.player.job.PlayerNotInJobException;
import com.equestricraft.mod.job.JobService;
import com.equestricraft.mod.packet.ClientBoundJobMenuScreenOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;

public class JobServiceImpl
implements JobService {
    @Service
    private JobSession jobSession;
    @Service
    private PlayerJobSession playerJobSession;
    @Service
    private JobRepository jobRepository;
    @Service
    private PlayerService playerService;

    @Override
    public void showJobMenuToPlayer(OnlinePlayer onlinePlayer, Job job) {
        JobInfo jobInfo = this.jobSession.retrieveJobInfo(job);
        ClientBoundJobMenuScreenOpenPacket packet = new ClientBoundJobMenuScreenOpenPacket(jobInfo);
        onlinePlayer.sendPacket(packet);
    }

    @Override
    public Response promotePlayer(OnlinePlayer playerPerformingPromotion, String jobIdentifier, String ign) {
        Job job = this.jobSession.retrieveJobByIdentifier(jobIdentifier);
        if (!this.canPromoteDemote(playerPerformingPromotion, job)) {
            return ResponseFactory.fail(I18n.getLabel("job.could-not-promote.prompt.title"), I18n.getLabel("job.managers-only"));
        }
        CorePlayer playerToPromote = this.playerService.retrievePlayerByIgn(ign);
        boolean promoted = playerToPromote.getJob().setCurrent(job);
        if (promoted) {
            return ResponseFactory.success(I18n.getLabel("job.promoted.prompt.title"), I18n.getLabel("job.player-promoted", playerToPromote.getIgn(), job.getName()));
        }
        return ResponseFactory.fail(I18n.getLabel("job.could-not-promote.prompt.title"), I18n.getLabel("job.player-already-in-job"));
    }

    @Override
    public Response demotePlayer(OnlinePlayer playerPerformingPromotion, String jobIdentifier, String ign) {
        Job job = this.jobSession.retrieveJobByIdentifier(jobIdentifier);
        if (!this.canPromoteDemote(playerPerformingPromotion, job)) {
            return ResponseFactory.fail(I18n.getLabel("job.could-not-demote.prompt.title"), I18n.getLabel("job.managers-only"));
        }
        CorePlayer playerToDemote = this.playerService.retrievePlayerByIgn(ign);
        try {
            playerToDemote.getJob().removeFromJob(job);
            this.playerJobSession.resetPlayerJobInduction(playerToDemote, job.getId());
            return ResponseFactory.success(I18n.getLabel("job.demoted.prompt.title"), I18n.getLabel("job.player-demoted", playerToDemote.getIgn(), job.getName()));
        }
        catch (PlayerNotInJobException ex) {
            return ResponseFactory.fail(I18n.getLabel("job.could-not-demote.prompt.title"), ex);
        }
    }

    private boolean canPromoteDemote(OnlinePlayer onlinePlayer, Job job) {
        boolean isJobManager = this.playerJobSession.isPlayerJobManager(onlinePlayer, job.getId());
        if (isJobManager) {
            return true;
        }
        return onlinePlayer.getPermission().hasPermission("equestricraft.job");
    }

    @Override
    public Response promotePlayerManager(OnlinePlayer playerPerformingPromotion, String jobIdentifier, String ign) {
        Job job = this.jobSession.retrieveJobByIdentifier(jobIdentifier);
        CorePlayer playerToPromote = this.playerService.retrievePlayerByIgn(ign);
        try {
            this.playerJobSession.setPlayerJobManager(playerToPromote, job.getId(), true);
            return ResponseFactory.success(I18n.getLabel("job.promoted.prompt.title"), I18n.getLabel("job.player-promoted-manager", playerToPromote.getIgn(), job.getName()));
        }
        catch (PlayerNotInJobException ex) {
            return ResponseFactory.fail(I18n.getLabel("job.could-not-promote.prompt.title"), ex);
        }
    }

    @Override
    public Response demotePlayerManager(OnlinePlayer playerPerformingDemotion, String jobIdentifier, String ign) {
        Job job = this.jobSession.retrieveJobByIdentifier(jobIdentifier);
        CorePlayer playerToDemote = this.playerService.retrievePlayerByIgn(ign);
        try {
            this.playerJobSession.setPlayerJobManager(playerToDemote, job.getId(), false);
            return ResponseFactory.success(I18n.getLabel("job.demoted.prompt.title"), I18n.getLabel("job.player-demoted-manager", playerToDemote.getIgn(), job.getName()));
        }
        catch (PlayerNotInJobException ex) {
            return ResponseFactory.fail(I18n.getLabel("job.could-not-demote.prompt.title"), ex);
        }
    }

    @Override
    public Response setPlayerFinishedInduction(String jobIdentifier, String ign) {
        Job job = this.jobSession.retrieveJobByIdentifier(jobIdentifier);
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        return this.setPlayerFinishedInduction(job, (ECPlayer)player);
    }

    @Override
    public Response setPlayerFinishedInduction(int jobId, ECPlayer player) {
        Job job = (Job)this.jobRepository.findByKey(jobId);
        return this.setPlayerFinishedInduction(job, player);
    }

    private Response setPlayerFinishedInduction(Job job, ECPlayer player) {
        try {
            this.playerJobSession.setPlayerFinishedInduction(player, job.getId());
            return ResponseFactory.success(I18n.getLabel("job.induction.player-completed", player.getIgn(), job.getName()));
        }
        catch (PlayerNotInJobException ex) {
            return ResponseFactory.fail(ex);
        }
    }
}

