/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job.activework;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.invoice.JobInvoice;
import com.equestricraft.core.job.invoice.JobInvoiceException;
import com.equestricraft.core.job.invoice.JobInvoiceSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.player.job.work.JobActiveWork;
import com.equestricraft.core.player.job.work.JobActiveWorkException;
import com.equestricraft.mod.job.activework.JobActiveInvoicePageService;
import com.equestricraft.mod.job.activework.JobActiveWorkService;
import com.equestricraft.mod.job.activework.JobInvoicePage;
import com.equestricraft.mod.packet.ClientBoundJobInvoicesMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundJobStartWorkMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.PlayerSearchPrompt;
import java.time.Duration;
import java.util.Optional;

public class JobActiveWorkServiceImpl
implements JobActiveWorkService {
    @Service
    private JobInvoiceSession jobInvoiceSession;
    @Service
    private JobActiveInvoicePageService jobActiveInvoicePageService;
    @Service
    private PlayerRepository playerRepository;

    @Override
    public Response showJobActiveWorkStartMenu(OnlinePlayer player) {
        if (player.getJob().getCurrent().isEmpty()) {
            return ResponseFactory.fail(I18n.getLabel("job.start-work.menu.title"), I18n.getLabel("job.start-work.not-in-job"));
        }
        Optional<ECPlayer> otherPlayer = PlayerSearchPrompt.showPlayerSearchPrompt(player);
        if (otherPlayer.isPresent()) {
            ClientBoundJobStartWorkMenuOpenPacket packet = new ClientBoundJobStartWorkMenuOpenPacket(otherPlayer.get().getId());
            player.sendPacket(packet);
        }
        return ResponseFactory.success();
    }

    @Override
    public Response startWork(OnlinePlayer playerPerforming, int otherPlayerId, String title, String description, double estimatedPrice) {
        if (playerPerforming.getJob().getWork().hasActiveWork()) {
            return ResponseFactory.fail(I18n.getLabel("job.start-work.confirm.title"), I18n.getLabel("job.start-work.already-got-active-work"));
        }
        Job job = playerPerforming.getJob().getCurrent().orElseThrow();
        CorePlayer otherPlayer = (CorePlayer)this.playerRepository.findByKey(otherPlayerId);
        ThreadUtils.sleep(Duration.ofMillis(500L));
        ConfirmResponse confirmation = otherPlayer.getConfirmation().confirm(I18n.getLabel("job.start-work.confirm.title"), I18n.getLabel("job.start-work.confirm.message", playerPerforming.getIgn(), title, EconomyUtilities.formatCurrency(estimatedPrice)));
        if (confirmation.isYes()) {
            JobActiveWork activeWork = new JobActiveWork(playerPerforming, otherPlayer, job, title, description, estimatedPrice);
            playerPerforming.getJob().getWork().setActiveWork(activeWork);
            return ResponseFactory.success(I18n.getLabel("job.start-work.confirm.title"), I18n.getLabel("job.start-work.confirmed"));
        }
        return ResponseFactory.fail(I18n.getLabel("job.start-work.confirm.title"), I18n.getLabel("job.start-work.rejected"));
    }

    @Override
    public Response completeWork(ECPlayer playerPerforming) throws JobActiveWorkException {
        JobActiveWork activeWork = playerPerforming.getJob().getWork().requireActiveWork();
        ConfirmResponse confirmation = activeWork.getOtherPlayer().getConfirmation().confirm(I18n.getLabel("job.complete-work.confirm.title"), I18n.getLabel("job.complete-work.confirm.message"));
        if (confirmation.isYes()) {
            JobInvoice invoice = this.jobInvoiceSession.createInvoice(playerPerforming, activeWork.getOtherPlayer(), activeWork.getJob(), activeWork.getEstimatedPrice(), activeWork.getTitle(), activeWork.getDescription());
            activeWork.getOtherPlayer().notify(I18n.getLabel("job.invoice.new-invoice-to-pay", invoice.getId(), playerPerforming.getIgn(), invoice.getTitle()));
            playerPerforming.getJob().getWork().setActiveWork(null);
            return ResponseFactory.success(I18n.getLabel("job.invoice.created", invoice.getId(), activeWork.getOtherPlayer().getIgn()));
        }
        return ResponseFactory.fail(I18n.getLabel("job.complete-work.confirm.title"), I18n.getLabel("job.complete-work.rejected"));
    }

    @Override
    public Response cancelWork(ECPlayer playerPerforming) throws JobActiveWorkException {
        JobActiveWork activeWork = playerPerforming.getJob().getWork().requireActiveWork();
        ConfirmResponse confirmation = activeWork.getOtherPlayer().getConfirmation().confirm(I18n.getLabel("job.cancel-work.confirm.title"), I18n.getLabel("job.cancel-work.confirm.message"));
        if (confirmation.isYes()) {
            playerPerforming.getJob().getWork().setActiveWork(null);
            return ResponseFactory.success("job.cancel-work.success");
        }
        return ResponseFactory.fail();
    }

    @Override
    public void showPlayersDueInvoices(OnlinePlayer player, int pageNumber) {
        JobInvoicePage page = this.jobActiveInvoicePageService.retrieveJobInvoicePage(player, pageNumber);
        ClientBoundJobInvoicesMenuOpenPacket packet = new ClientBoundJobInvoicesMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public Response payInvoice(OnlinePlayer player, int invoiceId) {
        try {
            this.jobInvoiceSession.payInvoice(invoiceId);
            return ResponseFactory.success(I18n.getLabel("job.invoice.pay.title"), I18n.getLabel("job.invoice.pay.success"));
        }
        catch (JobInvoiceException ex) {
            return ResponseFactory.fail(I18n.getLabel("job.invoice.pay.title"), ex);
        }
    }
}

