/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.job.requests;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSimple;
import com.equestricraft.core.job.JobTransformer;
import com.equestricraft.core.job.request.CreateJobRequestInfo;
import com.equestricraft.core.job.request.JobAvailableRequestPageSession;
import com.equestricraft.core.job.request.JobPlayersAssignedPageSession;
import com.equestricraft.core.job.request.JobRequest;
import com.equestricraft.core.job.request.JobRequestException;
import com.equestricraft.core.job.request.JobRequestPage;
import com.equestricraft.core.job.request.JobRequestRepository;
import com.equestricraft.core.job.request.JobRequestSession;
import com.equestricraft.mod.job.requests.JobRequestService;
import com.equestricraft.mod.packet.ClientBoundJobAssignedRequestsMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundJobAvailableRequestsMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class JobRequestServiceImpl
implements JobRequestService {
    @Service
    private JobAvailableRequestPageSession jobAvailableRequestPageSession;
    @Service
    private JobPlayersAssignedPageSession jobPlayersAssignedPageSession;
    @Service
    private JobRequestSession jobRequestSession;
    @Service
    private JobRequestRepository jobRequestRepository;
    @Service
    private JobRepository jobRepository;
    @Service
    private JobTransformer jobTransformer;

    @Override
    public Response showJobRequestMenuToPlayer(OnlinePlayer player) {
        Optional<Job> job = player.getJob().getCurrent();
        if (job.isPresent()) {
            this.showJobRequestPageToPlayer(player, job.get().getId(), 1);
            return ResponseFactory.success();
        }
        return ResponseFactory.fail(I18n.getLabel("job.not-in-job"));
    }

    @Override
    public void showJobRequestPageToPlayer(OnlinePlayer player, int jobId, int pageNumber) {
        JobRequestPage page = this.jobAvailableRequestPageSession.retrievePageOfAvailableRequestsForJob(jobId, pageNumber);
        Job job = (Job)this.jobRepository.findByKey(jobId);
        JobSimple jobSimple = this.jobTransformer.toSimple(job);
        ClientBoundJobAvailableRequestsMenuOpenPacket packet = new ClientBoundJobAvailableRequestsMenuOpenPacket(jobSimple, page);
        player.sendPacket(packet);
    }

    @Override
    public void showAssignedRequestsMenuToPlayer(OnlinePlayer player) {
        this.showPlayersAssignedRequestsPage(player, 1);
    }

    @Override
    public void showPlayersAssignedRequestsPage(OnlinePlayer player, int pageNumber) {
        JobRequestPage page = this.jobPlayersAssignedPageSession.retrievePageOfPlayersAssignedRequests(player.getId(), pageNumber);
        ClientBoundJobAssignedRequestsMenuOpenPacket packet = new ClientBoundJobAssignedRequestsMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public Response sendJobRequest(OnlinePlayer player, int jobId, String description) {
        EQHorse horse = player.getHorses().requiredSelected();
        CreateJobRequestInfo request = new CreateJobRequestInfo(player, jobId, horse.getId(), description);
        this.jobRequestSession.sendRequest(request);
        return ResponseFactory.success(I18n.getLabel("job.request-work.success"));
    }

    @Override
    public Response assignJobRequest(OnlinePlayer player, int requestId) {
        JobRequest request = (JobRequest)this.jobRequestRepository.findByKey(requestId);
        try {
            this.jobRequestSession.assignRequestToPlayer(request, player);
            return ResponseFactory.success(I18n.getLabel("job.request.assign.title"), I18n.getLabel("job.request.assign.success"));
        }
        catch (JobRequestException ex) {
            return ResponseFactory.fail(I18n.getLabel("job.request.assign.title", ex));
        }
    }

    @Override
    public Response completeJobRequest(OnlinePlayer player, int requestId) {
        JobRequest request = (JobRequest)this.jobRequestRepository.findByKey(requestId);
        if (request.getAssignedToId() == null || request.getRequesterId() != player.getId()) {
            return ResponseFactory.fail(I18n.getLabel("job.request.complete.title"), I18n.getLabel("job.request.complete.not-assigned-to-you"));
        }
        if (request.getCompleteTime() != null) {
            return ResponseFactory.fail(I18n.getLabel("job.request.complete.title"), I18n.getLabel("job.request.complete.already-completed"));
        }
        request.setCompleteTime(System.currentTimeMillis());
        request.save();
        return ResponseFactory.success(I18n.getLabel("job.request.complete.title"), I18n.getLabel("job.request.complete.success"));
    }
}

