/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.joinleavemessage;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.common.JoinLeaveMessageType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.joinleavemessage.JoinLeaveMessageSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.utilities.BroadcastMessageHelper;
import com.equestricraft.mod.joinleavemessage.JoinLeaveMessageService;
import java.util.Optional;

public class JoinLeaveMessageServiceImpl
implements JoinLeaveMessageService {
    @Service
    private JoinLeaveMessageSession joinLeaveMessageSession;

    @Override
    public void processJoinMessageForPlayer(ECPlayer player) {
        Optional<String> joinMessage;
        String messageToShow = player.getIgn();
        if (player.getDonator().isAtLeastDonatorLevel(DonatorLevel.EQUESTRIAN) && (joinMessage = this.joinLeaveMessageSession.getRandomByType(JoinLeaveMessageType.JOIN)).isPresent()) {
            messageToShow = joinMessage.get();
        }
        String translated = this.joinLeaveMessageSession.translatePlaceholders(player, messageToShow);
        BroadcastMessageHelper.broadcastMessage(I18n.getLabel("player.join.message", translated));
    }

    @Override
    public void processLeaveMessageForPlayer(ECPlayer player) {
        Optional<String> leaveMessage;
        String messageToShow = player.getIgn();
        if (player.getDonator().isAtLeastDonatorLevel(DonatorLevel.EQUESTRIAN) && (leaveMessage = this.joinLeaveMessageSession.getRandomByType(JoinLeaveMessageType.LEAVE)).isPresent()) {
            messageToShow = leaveMessage.get();
        }
        String translated = this.joinLeaveMessageSession.translatePlaceholders(player, messageToShow);
        BroadcastMessageHelper.broadcastMessage(I18n.getLabel("player.leave.message", translated));
    }
}

