/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.leaderboard;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.leaderboard.LeaderboardInfo;
import com.equestricraft.core.leaderboard.LeaderboardSession;
import com.equestricraft.core.leaderboard.LeaderboardSimpleInfo;
import com.equestricraft.mod.leaderboard.LeaderboardService;
import com.equestricraft.mod.packet.ClientBoundLeaderboardListScreenOpenPacket;
import com.equestricraft.mod.packet.ClientBoundLeaderboardScreenOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;

public class LeaderboardServiceImpl
implements LeaderboardService {
    @Service
    private LeaderboardSession leaderboardSession;

    @Override
    public void showLeaderboard(OnlinePlayer player, int leaderboardId) {
        LeaderboardInfo info2 = this.leaderboardSession.getLeaderboard(leaderboardId);
        ClientBoundLeaderboardScreenOpenPacket packet = new ClientBoundLeaderboardScreenOpenPacket(info2);
        player.sendPacket(packet);
    }

    @Override
    public boolean doesNpcHaveLeaderboards(int npcId) {
        return this.leaderboardSession.doAnyLeaderboardsUseNpc(npcId);
    }

    @Override
    public void showLeaderboardsForNpc(OnlinePlayer player, int npcId) {
        List<LeaderboardSimpleInfo> leaderboards = this.leaderboardSession.getLeaderboardsForNpc(npcId);
        if (leaderboards.size() == 1) {
            LeaderboardInfo leaderboard = this.leaderboardSession.getLeaderboard(leaderboards.get(0).leaderboardId());
            ClientBoundLeaderboardScreenOpenPacket packet = new ClientBoundLeaderboardScreenOpenPacket(leaderboard);
            player.sendPacket(packet);
        } else {
            ClientBoundLeaderboardListScreenOpenPacket packet = new ClientBoundLeaderboardListScreenOpenPacket(leaderboards);
            player.sendPacket(packet);
        }
    }
}

