/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.medicine;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.medicine.MedicineGiveResponse;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.player.medicine.MedicineInventoryItemInfo;
import com.equestricraft.core.player.medicine.MedicineInventorySession;
import com.equestricraft.mod.client.item.MedicineTool;
import com.equestricraft.mod.client.item.ModItems;
import com.equestricraft.mod.medicine.MedicineService;
import com.equestricraft.mod.packet.ClientBoundPlayerMedicineListOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import com.equestricraft.mod.util.ComponentUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MedicineServiceImpl
implements MedicineService {
    @Service
    private MedicineInventorySession medicineInventorySession;
    @Service
    private MedicineRepository medicineRepository;
    @Service
    private HorseRepository horseRepository;

    @Override
    public Response giveMedicineToolToPlayer(OnlinePlayer player) {
        MedicineTool item = ModItems.getMedicineTool();
        ItemStack tool = new ItemStack((ItemLike)item);
        tool.m_41714_((Component)ComponentUtil.buildColoredTextComponent("Medicine Tool"));
        player.serverPlayer().m_150109_().m_36054_(tool);
        return ResponseFactory.success();
    }

    @Override
    public void showPlayersMedicineMenu(OnlinePlayer player, EQHorse horse) {
        List<MedicineInventoryItemInfo> medicine = this.medicineInventorySession.retrieveListOfMedicinesItemsPlayerHas(player);
        ClientBoundPlayerMedicineListOpenPacket packet = new ClientBoundPlayerMedicineListOpenPacket(horse.getId(), medicine);
        player.sendPacket(packet);
    }

    @Override
    public Response giveMedicineToHorse(OnlinePlayer player, int medicineId, int horseId) {
        Medicine medicine = (Medicine)this.medicineRepository.findByKey(medicineId);
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Optional<Number> dosage = NumberInputPrompt.showNumberInputPrompt(player, I18n.getLabel("medicine.give.title", medicine.getName()), I18n.getLabel("medicine.give.enter-dosage-count", medicine.getSingleDosageSize()));
        if (dosage.isPresent()) {
            int count = dosage.get().intValue();
            MedicineGiveResponse response = horse.getMedicine().giveAmount(medicine, count * medicine.getSingleDosageSize());
            this.medicineInventorySession.removeItemFromInventory(player, medicine, count);
            return ResponseFactory.success(I18n.getLabel("medicine.give.success", response.medicineName(), horse.getName()));
        }
        return ResponseFactory.fail();
    }
}

