/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.movement;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.movement.PlayerMoveEvent;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class MovementListener {
    private static final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @SubscribeEvent
    public static void onMove(LivingEvent.LivingUpdateEvent event) {
        ServerPlayer serverPlayer;
        Optional<ECPlayer> player;
        LivingEntity livingEntity;
        if (event.getEntityLiving() != null && (livingEntity = event.getEntityLiving()) instanceof ServerPlayer && (player = onlinePlayerCache.getPlayer((serverPlayer = (ServerPlayer)livingEntity).m_142081_())).isPresent()) {
            Coordinate last;
            ECPlayer p = player.get();
            ECLevel level = ServerLevelUtil.getEntitiesECLevel((Entity)serverPlayer);
            Coordinate nextLocation = new Coordinate(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), level.getIdentifier());
            Optional<Coordinate> lastLocation = p.getLocation().getLast();
            if (lastLocation.isPresent() && !(last = lastLocation.get()).equals(nextLocation)) {
                OnlinePlayer onlinePlayer = p.require(OnlinePlayer.class);
                PlayerMoveEvent moveEvent = new PlayerMoveEvent(onlinePlayer, last, nextLocation);
                MinecraftForge.EVENT_BUS.post((Event)moveEvent);
                if (moveEvent.isCanceled()) {
                    serverPlayer.m_6021_(last.x(), last.y(), last.z());
                    return;
                }
            }
            p.getLocation().setLast(nextLocation);
        }
    }

    @SubscribeEvent
    public static void onJoin(ECPlayerJoinEvent event) {
        OnlinePlayer onlinePlayer = event.getPlayer().require(OnlinePlayer.class);
        Coordinate location = onlinePlayer.getCoordinate();
        PlayerMoveEvent moveEvent = new PlayerMoveEvent(onlinePlayer, location, location);
        MinecraftForge.EVENT_BUS.post((Event)moveEvent);
        onlinePlayer.getLocation().setLast(location);
    }

    private MovementListener() {
    }
}

