/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.navigator;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.navigator.NavigatorItem;
import com.equestricraft.core.navigator.NavigatorItemInfo;
import com.equestricraft.core.navigator.NavigatorItemRepository;
import com.equestricraft.core.navigator.NavigatorItemSession;
import com.equestricraft.mod.gamemode.GameModeService;
import com.equestricraft.mod.navigator.NavigatorService;
import com.equestricraft.mod.packet.ClientBoundNavigatorOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.List;
import java.util.UUID;

public class NavigatorServiceImpl
implements NavigatorService {
    @Service
    private NavigatorItemSession navigatorItemSession;
    @Service
    private NavigatorItemRepository navigatorItemRepository;
    @Service
    private GameModeService gameModeService;

    @Override
    public Response showNavigatorMenuToPlayer(OnlinePlayer player) {
        List<NavigatorItemInfo> items = this.navigatorItemSession.getItems();
        ClientBoundNavigatorOpenPacket packet = new ClientBoundNavigatorOpenPacket(items);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response teleportToNavigatorPosition(OnlinePlayer player, UUID id) {
        NavigatorItem item = (NavigatorItem)this.navigatorItemRepository.findByKey(id);
        this.gameModeService.setAdventure(player);
        player.getLocation().teleport(item.getCoordinate());
        return ResponseFactory.success(I18n.getLabel("navigator.tp.success", item.getName()));
    }
}

