/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.network;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.network.PacketChannelHandler;
import com.equestricraft.mod.player.OnlinePlayer;
import net.minecraft.server.level.ServerPlayer;

public class Network {
    private static final PacketChannelHandler packetChannelHandler = PacketChannelHandler.getInstance();

    public static <P> void sendToServer(P packet) {
        packetChannelHandler.sendPacketToServer(packet);
    }

    public static <P> boolean sendToPlayer(ECPlayer player, P packet) {
        if (player.isOnline()) {
            ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
            Network.sendToPlayer(serverPlayer, packet);
            return true;
        }
        return false;
    }

    public static <P> void sendToPlayer(ServerPlayer player, P packet) {
        packetChannelHandler.sendToPlayer(player, packet);
    }

    public static <P> void sendToAll(P packet) {
        packetChannelHandler.sendToAll(packet);
    }

    private Network() {
    }
}

