/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.network;

import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.core.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannelHandler {
    private static final PacketChannelHandler instance = new PacketChannelHandler();
    private final List<ChannelRegistration> registrations = new ArrayList<ChannelRegistration>(0);
    private final Map<Class<?>, SimpleChannel> packetChannelMap = new HashMap();

    public static PacketChannelHandler getInstance() {
        return instance;
    }

    private PacketChannelHandler() {
    }

    protected <T> void sendPacketToServer(T packet) {
        if (!Context.isClient()) {
            throw new UnsupportedOperationException("Cannot send packets to server from server side");
        }
        SimpleChannel channel = this.findChannelForPacket(packet.getClass());
        channel.sendToServer(packet);
    }

    protected <T> void sendToPlayer(ServerPlayer player, T packet) {
        if (!Context.isServer()) {
            throw new UnsupportedOperationException("Cannot send packets to player from client side");
        }
        SimpleChannel channel = this.findChannelForPacket(packet.getClass());
        channel.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    protected <T> void sendToAll(T packet) {
        if (!Context.isServer()) {
            throw new UnsupportedOperationException("Cannot send packets to players from client side");
        }
        SimpleChannel channel = this.findChannelForPacket(packet.getClass());
        channel.send(PacketDistributor.ALL.noArg(), packet);
    }

    private SimpleChannel findChannelForPacket(Class<?> packetClass) {
        return this.packetChannelMap.get(packetClass);
    }

    protected <T> void registerServerBoundPacket(Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, SimpleChannel.MessageBuilder.ToBooleanBiFunction<T, Supplier<NetworkEvent.Context>> handler) {
        this.registerPacket(packetClass, NetworkDirection.PLAY_TO_SERVER, encoder, decoder, handler);
    }

    protected <T> void registerClientBoundPacket(Class<T> packetClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, SimpleChannel.MessageBuilder.ToBooleanBiFunction<T, Supplier<NetworkEvent.Context>> handler) {
        this.registerPacket(packetClass, NetworkDirection.PLAY_TO_CLIENT, encoder, decoder, handler);
    }

    private synchronized <T> void registerPacket(Class<T> packetClass, NetworkDirection direction, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, SimpleChannel.MessageBuilder.ToBooleanBiFunction<T, Supplier<NetworkEvent.Context>> handler) {
        ChannelRegistration registration = this.getAvailableRegistration();
        registration.getChannel().messageBuilder(packetClass, registration.getNextPacketId(), direction).encoder(encoder).decoder(decoder).consumer(handler).add();
        registration.increasePacketCount();
        this.packetChannelMap.put(packetClass, registration.getChannel());
    }

    private ChannelRegistration getAvailableRegistration() {
        for (ChannelRegistration registration : this.registrations) {
            if (!registration.hasSpace()) continue;
            return registration;
        }
        SimpleChannel newChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("equestricraft", String.format("main%s", this.registrations.size() + 1)), () -> BuildInformation.get().getVersionString(), BuildInformation.get().getVersionString()::equals, BuildInformation.get().getVersionString()::equals);
        ChannelRegistration newRegistration = new ChannelRegistration(newChannel);
        this.registrations.add(newRegistration);
        return newRegistration;
    }

    private static class ChannelRegistration {
        private final SimpleChannel channel;
        private int nextPacketId;

        public ChannelRegistration(SimpleChannel channel) {
            this.channel = channel;
        }

        public SimpleChannel getChannel() {
            return this.channel;
        }

        public int getNextPacketId() {
            return this.nextPacketId;
        }

        public void increasePacketCount() {
            ++this.nextPacketId;
        }

        public boolean hasSpace() {
            return this.nextPacketId < 256;
        }
    }
}

