/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.nickname;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.command.argproviders.OnlinePlayersArgumentSuggestionProvider;
import com.equestricraft.mod.context.ModPlayerContext;
import com.equestricraft.mod.nickname.NicknameService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

@Command(value="nickname")
public class NicknameCommand {
    @Service
    private NicknameService nicknameService;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Async
    @Command
    public Response onNickname() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.nicknameService.promptNicknameChange(player);
    }

    @Async
    @Command
    @Permission(value="equestricraft.nickname.change-other")
    public Response onOtherPlayerNickname(@Arg(suggestionProvider=OnlinePlayersArgumentSuggestionProvider.class) String playerIgn, @Arg String newNickname) {
        Optional<ECPlayer> player = this.onlinePlayerCache.getPlayer(playerIgn);
        if (player.isPresent()) {
            return this.nicknameService.changeNickname(player.get(), newNickname);
        }
        return ResponseFactory.fail(I18n.getLabel("player.not-online"));
    }

    @Async
    @Command(value="builder")
    public Response onBuilder() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.nicknameService.showNicknameBuilderToPlayer(player);
    }

    @Async
    @Command(value="advanced")
    public Response onAdvanced() {
        OnlinePlayer player = ModPlayerContext.getOnlinePlayer();
        return this.nicknameService.showAdvancedNicknameMenuToPlayer(player);
    }
}

