/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.nickname;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.nickname.AdvancedNicknameChangeRequest;
import com.equestricraft.mod.nickname.AdvancedNicknameLetter;
import com.equestricraft.mod.nickname.NicknameChangeRequest;
import com.equestricraft.mod.nickname.NicknameLetter;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;

public class NicknameSerializer {
    public static void serializeNicknameChangeRequest(NicknameChangeRequest request, FriendlyByteBuf buffer) {
        buffer.writeInt(request.letters().size());
        for (NicknameLetter letter : request.letters()) {
            buffer.writeChar((int)letter.letter().charValue());
            buffer.m_130070_(letter.color());
        }
        buffer.writeBoolean(request.bold());
        buffer.writeBoolean(request.italic());
    }

    public static NicknameChangeRequest deserializeNicknameChangeRequest(FriendlyByteBuf buffer) {
        int lettersCount = buffer.readInt();
        ArrayList<NicknameLetter> letters = new ArrayList<NicknameLetter>(lettersCount);
        for (int i = 0; i < lettersCount; ++i) {
            char character = buffer.readChar();
            String color = buffer.m_130277_();
            NicknameLetter letter = new NicknameLetter(Character.valueOf(character), color);
            letters.add(letter);
        }
        boolean bold = buffer.readBoolean();
        boolean italic = buffer.readBoolean();
        return new NicknameChangeRequest(letters, bold, italic);
    }

    public static void serializeAdvancedNicknameChangeRequest(AdvancedNicknameChangeRequest request, FriendlyByteBuf buffer) {
        buffer.writeInt(request.letters().size());
        for (AdvancedNicknameLetter letter : request.letters()) {
            buffer.writeChar((int)letter.letter().charValue());
            buffer.writeInt(letter.color().getIntValue());
        }
        buffer.writeBoolean(request.bold());
        buffer.writeBoolean(request.italic());
    }

    public static AdvancedNicknameChangeRequest deserializeAdvancedNicknameChangeRequest(FriendlyByteBuf buffer) {
        int lettersCount = buffer.readInt();
        ArrayList<AdvancedNicknameLetter> letters = new ArrayList<AdvancedNicknameLetter>(lettersCount);
        for (int i = 0; i < lettersCount; ++i) {
            char character = buffer.readChar();
            Argb color = Argb.fromIntValue(buffer.readInt());
            AdvancedNicknameLetter letter = new AdvancedNicknameLetter(Character.valueOf(character), color);
            letters.add(letter);
        }
        boolean bold = buffer.readBoolean();
        boolean italic = buffer.readBoolean();
        return new AdvancedNicknameChangeRequest(letters, bold, italic);
    }

    private NicknameSerializer() {
    }
}

