/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.nickname;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.blockedphrase.BlockedPhraseException;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.core.player.nickname.AdvancedNickname;
import com.equestricraft.core.player.nickname.NicknameChangeException;
import com.equestricraft.core.player.nickname.NicknameSession;
import com.equestricraft.core.player.nickname.SimpleNickname;
import com.equestricraft.mod.nickname.AdvancedNicknameChangeRequest;
import com.equestricraft.mod.nickname.AdvancedNicknameLetter;
import com.equestricraft.mod.nickname.NicknameChangeRequest;
import com.equestricraft.mod.nickname.NicknameLetter;
import com.equestricraft.mod.nickname.NicknameService;
import com.equestricraft.mod.packet.ClientBoundNicknameBuilderOpenPacket;
import com.equestricraft.mod.packet.ClientBoundShowAdvancedNicknameChangeMenuPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.ArrayList;
import java.util.Optional;

public class NicknameServiceImpl
implements NicknameService {
    @Service
    private NicknameSession nicknameSession;
    @Service
    private PlayerService playerService;
    @Service
    private BlockedPhraseService blockedPhraseService;

    @Override
    public Response changeNickname(ECPlayer player, String newNickname) {
        SimpleNickname nickname = new SimpleNickname(newNickname);
        try {
            this.blockedPhraseService.ensureNoBlockedPhrases(nickname.toString());
            this.nicknameSession.changePlayerNicknameNoCharge(player, new SimpleNickname(newNickname));
            return ResponseFactory.success(I18n.getLabel("nickname.changed", newNickname));
        }
        catch (BlockedPhraseException ex) {
            return ResponseFactory.fail(I18n.getLabel("nickname.change.prompt.title"), ex);
        }
    }

    @Override
    public Response changeNicknameWithCharge(OnlinePlayer player, NicknameChangeRequest request) {
        String nickname = request.toString();
        try {
            this.blockedPhraseService.ensureNoBlockedPhrases(nickname);
            ConfirmResponse confirmResponse = player.getConfirmation().confirm(I18n.getLabel("nickname.change.prompt.title"), I18n.getLabel("nickname.change.confirm", nickname));
            if (confirmResponse.isYes()) {
                try {
                    this.nicknameSession.changePlayerNicknameWithCharge(player, new SimpleNickname(nickname));
                    return ResponseFactory.success(I18n.getLabel("nickname.change.prompt.title"), I18n.getLabel("nickname.changed", request));
                }
                catch (NicknameChangeException ex) {
                    return ResponseFactory.fail(I18n.getLabel("nickname.change.prompt.title"), ex);
                }
            }
            if (confirmResponse.isNo()) {
                this.showNicknameBuilder(player, request);
            }
            return ResponseFactory.fail();
        }
        catch (BlockedPhraseException ex) {
            return ResponseFactory.fail(I18n.getLabel("nickname.change.prompt.title"), ex);
        }
    }

    @Override
    public Response changeNicknameWithCharge(OnlinePlayer player, AdvancedNicknameChangeRequest request) {
        AdvancedNickname.Builder advancedNicknameBuilder = AdvancedNickname.Builder.start().withBold(request.bold()).withUnderline(request.italic());
        for (AdvancedNicknameLetter letter : request.letters()) {
            advancedNicknameBuilder.withAdvancedLetter(letter.letter().toString(), letter.color());
        }
        AdvancedNickname nickname = advancedNicknameBuilder.complete();
        try {
            this.blockedPhraseService.ensureNoBlockedPhrases(nickname.toString());
            ConfirmResponse confirmResponse = player.getConfirmation().confirm(I18n.getLabel("nickname.change.prompt.title"), I18n.getLabel("nickname.change.confirm", nickname));
            if (confirmResponse.isYes()) {
                try {
                    this.nicknameSession.changePlayerNicknameWithCharge(player, nickname);
                    return ResponseFactory.success(I18n.getLabel("nickname.change.prompt.title"), I18n.getLabel("nickname.changed", nickname));
                }
                catch (NicknameChangeException ex) {
                    return ResponseFactory.fail(I18n.getLabel("nickname.change.prompt.title", ex));
                }
            }
            if (confirmResponse.isNo()) {
                this.showAdvancedNicknameScreen(player, request);
            }
            return ResponseFactory.fail();
        }
        catch (BlockedPhraseException ex) {
            return ResponseFactory.fail(I18n.getLabel("nickname.change.prompt.title", ex));
        }
    }

    @Override
    public Response promptNicknameChange(OnlinePlayer player) {
        if (!this.nicknameSession.canChangeNickname(player)) {
            return ResponseFactory.fail(I18n.getLabel("nickname.no-tokens-left"));
        }
        return this.showPrompt(player);
    }

    private Response showPrompt(OnlinePlayer player) {
        return this.showPrompt(player, null);
    }

    private Response showPrompt(OnlinePlayer player, String nickname) {
        TextInputPrompt prompt = TextInputPrompt.create().withTitle(I18n.getLabel("nickname.change.prompt.title")).withText(I18n.getLabel("nickname.change.prompt.message")).withMaximumLength(2000).withDefaultValue(nickname).build();
        Optional<String> newNickname = prompt.show(player);
        if (newNickname.isPresent()) {
            ConfirmResponse confirmResponse = player.getConfirmation().confirm(I18n.getLabel("nickname.change.prompt.title"), I18n.getLabel("nickname.change.confirm", newNickname.get()));
            if (confirmResponse.isYes()) {
                try {
                    this.nicknameSession.changePlayerNicknameWithCharge(player, new SimpleNickname(newNickname.get()));
                    return ResponseFactory.success(I18n.getLabel("nickname.change.prompt.title"), I18n.getLabel("nickname.change.tokens-used", newNickname.get(), player.getTokens().getNicknameTokenCount()));
                }
                catch (NicknameChangeException ex) {
                    return ResponseFactory.fail(I18n.getLabel("nickname.change.prompt.title"), ex);
                }
            }
            if (confirmResponse.isNo()) {
                return this.showPrompt(player, newNickname.get());
            }
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response giveNicknameTokensToPlayer(ECPlayer player, int amount) {
        player.getTokens().giveNicknameTokens(amount);
        return ResponseFactory.success(I18n.getLabel("nickname.tokens-given", amount, player.getTokens().getNicknameTokenCount()));
    }

    @Override
    public Response giveNicknameTokensToPlayer(String ign, int amount) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        return this.giveNicknameTokensToPlayer(player, amount);
    }

    @Override
    public Response showNicknameBuilderToPlayer(OnlinePlayer player) {
        if (!this.nicknameSession.canChangeNickname(player)) {
            return ResponseFactory.fail(I18n.getLabel("nickname.no-tokens-left"));
        }
        this.showNicknameBuilder(player, new NicknameChangeRequest(new ArrayList<NicknameLetter>(0), false, false));
        return ResponseFactory.success();
    }

    private void showNicknameBuilder(OnlinePlayer player, NicknameChangeRequest request) {
        boolean canUseFormattingCodes = this.nicknameSession.canUseFormattingCodes(player);
        ClientBoundNicknameBuilderOpenPacket packet = new ClientBoundNicknameBuilderOpenPacket(canUseFormattingCodes, request);
        player.sendPacket(packet);
    }

    @Override
    public Response showAdvancedNicknameMenuToPlayer(OnlinePlayer player) {
        AdvancedNicknameChangeRequest request = new AdvancedNicknameChangeRequest(new ArrayList<AdvancedNicknameLetter>(0), false, false);
        this.showAdvancedNicknameScreen(player, request);
        return ResponseFactory.success();
    }

    private void showAdvancedNicknameScreen(OnlinePlayer player, AdvancedNicknameChangeRequest request) {
        ClientBoundShowAdvancedNicknameChangeMenuPacket packet = new ClientBoundShowAdvancedNicknameChangeMenuPacket(request);
        player.sendPacket(packet);
    }
}

