/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.npc;

import com.equestricraft.common.ListMap;
import com.equestricraft.mod.npc.NPCAction;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;

public class NPCActionCache {
    private static final NPCActionCache instance = new NPCActionCache();
    private final ListMap<UUID, NPCAction> playerActionListMap = new ListMap();
    private final StampedLock lock = new StampedLock();

    public static NPCActionCache getInstance() {
        return instance;
    }

    private NPCActionCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayersActions(UUID playerUuid, List<NPCAction> actions) {
        long stamp = this.lock.writeLock();
        try {
            this.playerActionListMap.clear(playerUuid);
            actions.forEach(a -> this.playerActionListMap.add(playerUuid, (NPCAction)a));
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NPCAction> getPlayersActions(UUID playerUuid) {
        long stamp = this.lock.readLock();
        try {
            List<NPCAction> list = this.playerActionListMap.get(playerUuid);
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPlayersActions(UUID playerUuid) {
        long stamp = this.lock.writeLock();
        try {
            this.playerActionListMap.clear(playerUuid);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

