/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.npc;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseGaitVariant;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.horse.gait.Walk;
import com.equestricraft.core.horse.texture.HorseTextureDetails;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.horse.entity.GroundTractionPercentage;
import com.equestricraft.mod.horse.entity.HorseEntitySession;
import com.equestricraft.mod.horse.entity.HorseSpawnData;
import com.equestricraft.mod.npc.NPCHorseEntitySession;
import java.util.function.Consumer;

public class NPCHorseEntitySessionImpl
implements NPCHorseEntitySession {
    @Service
    private HorseEntitySession horseEntitySession;

    @Override
    public EntityHorse createNpcHorse(NPC npc, Consumer<EntityHorse> preSpawnAction) {
        return this.createNpcHorse(npc, npc.getLocation(), preSpawnAction);
    }

    @Override
    public EntityHorse createNpcHorse(NPC npc, DirectionalCoordinate directionalCoordinate, Consumer<EntityHorse> preSpawnAction) {
        return this.horseEntitySession.spawnHorse(npc.getId(), HorseEntityType.NPC, directionalCoordinate, this.createHorseSpawnData(npc), preSpawnAction);
    }

    private HorseSpawnData createHorseSpawnData(NPC npc) {
        return new HorseSpawnData(HorseTextureDetails.withOverride(npc.getSkinTexture()), 1.0f, 0.0f, Walk.WORKING, HorseGaitVariant.STANDARD, GroundTractionPercentage.getDefault());
    }
}

