/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.npc;

import com.equestricraft.base.eventbus.ECEventBusListener;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCFollowPlayerSetEvent;
import com.equestricraft.core.npc.NPCFollowPlayerStopEvent;
import com.equestricraft.core.npc.NPCResetForPlayerEvent;
import com.equestricraft.core.npc.NPCSetTempForPlayerEvent;
import com.equestricraft.core.npc.NPCTpPlayerNpcEvent;
import com.equestricraft.core.npc.NPCWaypointSetEvent;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.client.npc.EntityNPC;
import com.equestricraft.mod.npc.NPCActionCache;
import com.equestricraft.mod.npc.NPCSession;
import com.equestricraft.mod.npc.NpcEntityCache;
import com.equestricraft.mod.player.ECPlayerLeaveEvent;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public final class NPCListener {
    @Service
    private static NPCSession npcSession;
    private static final NpcEntityCache npcEntityCache;
    private static final NPCActionCache npcActionCache;

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkPos pos = event.getChunk().m_7697_();
        NPCListener.clearNpcsInChunk((ServerLevel)event.getWorld().m_7726_().m_7653_(), pos);
        TaskScheduler.executeSyncTask(() -> {
            ECLevel ecLevel = ServerLevelUtil.getECLevel((Level)((ServerLevel)event.getWorld().m_7726_().m_7653_()));
            List<NPC> npcsInChunk = npcEntityCache.findMainEntitiesInChunk(ecLevel, pos);
            npcsInChunk.stream().filter(Predicate.not(n -> npcEntityCache.isNpcActive(n.getId()))).forEach(n -> TaskScheduler.executeAsyncTask(() -> npcSession.spawnMainNPC((NPC)n)));
        });
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        ServerLevel serverLevel = (ServerLevel)event.getWorld().m_7726_().m_7653_();
        ChunkPos pos = event.getChunk().m_7697_();
        NPCListener.clearNpcsInChunk(serverLevel, pos);
    }

    private static void clearNpcsInChunk(ServerLevel level, ChunkPos chunkPos) {
        for (EntityNPC entity : level.m_143280_(EntityTypeTest.m_156916_(EntityNPC.class), e -> e.m_146902_().equals((Object)chunkPos))) {
            npcSession.deSpawnNPC(entity);
        }
        List horseNpcsToRemove = level.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), horse -> {
            if (horse.getHorseEntityType() != HorseEntityType.NPC) {
                return false;
            }
            return horse.m_146902_().equals((Object)chunkPos);
        });
        horseNpcsToRemove.forEach(npcSession::deSpawnNPC);
    }

    @SubscribeEvent
    public static void onNpcInteract(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityNPC) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void clearMenuActionsOnLeave(ECPlayerLeaveEvent event) {
        npcActionCache.clearPlayersActions(event.getPlayer().getAccountUuid());
    }

    @ECEventBusListener
    public static void onSetTempNpcEvent(NPCSetTempForPlayerEvent event) {
        npcSession.setTempNPCsForPlayer(event.getPlayer());
    }

    @ECEventBusListener
    public static void onResetNpcEvent(NPCResetForPlayerEvent event) {
        npcSession.resetNPCsForPlayer(event.getPlayer());
    }

    @ECEventBusListener
    public static void onSetNpcWaypointEvent(NPCWaypointSetEvent event) {
        npcSession.setWaypointForNpc(event.getNpc(), event.getPlayer(), event.getWaypoint(), event.getSpeed(), event.getOnReachAction(), event.getMinimumDistance(), event.getMinimumDistanceInitialAction(), event.getMinimumDistanceTimeLimit(), event.getOnMinimumDistanceAction(), event.getMaximumDistance(), event.getMaximumDistanceInitialAction(), event.getMaximumDistanceTimeLimit(), event.getOnMaximumDistanceAction());
    }

    @ECEventBusListener
    public static void onSetNpcFollowPlayerSetEvent(NPCFollowPlayerSetEvent event) {
        npcSession.setNpcFollowPlayer(event.getNpc(), event.getPlayer(), event.getSpeed());
    }

    @ECEventBusListener
    public static void setNpcFollowPlayerStopEvent(NPCFollowPlayerStopEvent event) {
        npcSession.stopNpcFollowPlayer(event.getNpc(), event.getPlayer());
    }

    @ECEventBusListener
    public static void onPlayerNpcTpEvent(NPCTpPlayerNpcEvent event) {
        Coordinate location = event.getLocation();
        DirectionalCoordinate coordinate = new DirectionalCoordinate(location.x(), location.y(), location.z(), location.world(), 0.0f, 0.0f);
        npcSession.spawnPlayerOnlyNPC(event.getNpc(), event.getPlayer(), coordinate);
    }

    @SubscribeEvent
    public static void clearNpcsOnLeave(ECPlayerLeaveEvent event) {
        npcSession.resetNPCsForPlayer(event.getPlayer());
    }

    private NPCListener() {
    }

    static {
        npcEntityCache = NpcEntityCache.getInstance();
        npcActionCache = NPCActionCache.getInstance();
    }
}

