/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.npc;

import com.equestricraft.base.ClickType;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ListMap;
import com.equestricraft.common.NPCBodyType;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.PredicateUtils;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.EntityInit;
import com.equestricraft.mod.client.CustomLookAtPlayerGoal;
import com.equestricraft.mod.client.CustomRandomLookAroundGoal;
import com.equestricraft.mod.client.ECNpc;
import com.equestricraft.mod.client.MobWaypointDistancePolicy;
import com.equestricraft.mod.client.MobWaypointFollowGoal;
import com.equestricraft.mod.client.horse.EntityHorse;
import com.equestricraft.mod.client.horse.HorseEntityType;
import com.equestricraft.mod.client.npc.EntityNPC;
import com.equestricraft.mod.horse.HorseWaypointFollowGoal;
import com.equestricraft.mod.npc.NPCAction;
import com.equestricraft.mod.npc.NPCActionCache;
import com.equestricraft.mod.npc.NPCHorseEntitySession;
import com.equestricraft.mod.npc.NPCInteractEvent;
import com.equestricraft.mod.npc.NPCSession;
import com.equestricraft.mod.npc.NpcActionInfo;
import com.equestricraft.mod.npc.NpcEntityCache;
import com.equestricraft.mod.npc.NpcFollowPlayerGoal;
import com.equestricraft.mod.packet.ClientBoundNPCActionMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.GoalUtil;
import com.equestricraft.mod.util.ServerLevelUtil;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class NPCSessionImpl
implements NPCSession {
    @Service
    private NPCRepository npcRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private NPCHorseEntitySession npcHorseEntitySession;
    private final NpcEntityCache npcEntityCache = NpcEntityCache.getInstance();
    private final NPCActionCache npcActionCache = NPCActionCache.getInstance();
    private final Object npcResetLock = new Object();
    private static final Log log = Log.getLogger(NPCSessionImpl.class.getName());

    @Override
    public void npcInteracted(OnlinePlayer onlinePlayer, NPC npc, ClickType clickType) {
        NPCInteractEvent event = new NPCInteractEvent(onlinePlayer, npc, clickType);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        if (!cancelled) {
            List<NPCAction> actions = event.getActions();
            if (!actions.isEmpty()) {
                if (actions.size() == 1) {
                    actions.get(0).action().run();
                } else {
                    this.npcActionCache.setPlayersActions(onlinePlayer.getAccountUuid(), actions);
                    List<NpcActionInfo> actionInfoList = this.buildNpcActionInfoList(actions);
                    ClientBoundNPCActionMenuOpenPacket packet = new ClientBoundNPCActionMenuOpenPacket(npc.getName(), actionInfoList);
                    onlinePlayer.sendPacket(packet);
                }
            } else if (!npc.getBackgroundTalks().isEmpty()) {
                String randomBackgroundTalk = ListUtils.getRandomItem(npc.getBackgroundTalks());
                onlinePlayer.sendMessage(randomBackgroundTalk);
            }
        }
    }

    private List<NpcActionInfo> buildNpcActionInfoList(List<NPCAction> actions) {
        return actions.stream().map(a -> new NpcActionInfo(a.label(), a.identifier())).sorted(Comparator.comparing(NpcActionInfo::label)).toList();
    }

    @Override
    public void spawnMainNPC(NPC npc) {
        if (npc.isHidden()) {
            return;
        }
        DirectionalCoordinate location = npc.getLocation();
        ServerLevel level = ServerLevelUtil.getServerLevel(location.world());
        if (npc.getNpcBodyType() == NPCBodyType.HORSE) {
            this.npcHorseEntitySession.createNpcHorse(npc, ECNpc::setAsGlobal);
        } else {
            EntityNPC entity = (EntityNPC)((EntityType)EntityInit.NPC_ENTITY.get()).m_20615_((Level)level);
            if (entity == null) {
                throw new IllegalArgumentException(String.format("Unable to create NPC %s in world %s", npc.getId(), location.world()));
            }
            entity.m_146926_(location.rotationX());
            entity.m_146922_(location.rotationY());
            entity.m_5616_(location.rotationY());
            entity.m_5618_(location.rotationY());
            entity.m_6034_(location.x(), location.y(), location.z());
            entity.setInternalId(npc.getId());
            entity.setTextureBase64(npc.getSkinTexture());
            entity.m_6593_(Component.m_130674_((String)npc.getName()));
            entity.setAsGlobal();
            entity.m_141960_(new EntityInLevelCallback(){

                public void m_142044_() {
                }

                public void m_142472_(Entity.RemovalReason removalReason) {
                }
            });
            boolean added = TaskScheduler.executeAwaitSyncTask(() -> level.m_7967_((Entity)entity.asMob()));
            GoalUtil.findGoal(entity, CustomRandomLookAroundGoal.class).setShouldLookAround(!npc.isFreeze());
            GoalUtil.findGoal(entity, CustomLookAtPlayerGoal.class).setShouldLookAtPlayer(!npc.isFreeze());
            if (!added) {
                throw new IllegalArgumentException("Unable to spawn npc entity");
            }
        }
    }

    @Override
    public void setTempNPCsForPlayer(ECPlayer player) {
        List<NPC> npcs = this.npcRepository.findAllEnabled();
        for (NPC npc : npcs) {
            this.spawnPlayerOnlyNPC(npc, player, npc.getLocation());
            this.hideMainNpcForPlayer(npc, player);
        }
    }

    @Override
    public void spawnPlayerOnlyNPC(NPC npc, ECPlayer player, DirectionalCoordinate location) {
        ServerLevel level = ServerLevelUtil.getServerLevel(location.world());
        if (npc.getNpcBodyType() == NPCBodyType.HORSE) {
            this.npcHorseEntitySession.createNpcHorse(npc, location, e -> e.setPrivateForPlayer(player));
        } else {
            EntityNPC entity = (EntityNPC)((EntityType)EntityInit.NPC_ENTITY.get()).m_20615_((Level)level);
            if (entity == null) {
                throw new IllegalArgumentException(String.format("Unable to create NPC %s in world %s", npc.getId(), location.world()));
            }
            entity.m_6034_(location.x(), location.y(), location.z());
            entity.m_146926_(location.rotationX());
            entity.m_146922_(location.rotationY());
            entity.setInternalId(npc.getId());
            entity.setTextureBase64(npc.getSkinTexture());
            entity.m_6593_(Component.m_130674_((String)npc.getName()));
            entity.setPrivateForPlayer(player);
            boolean added = TaskScheduler.executeAwaitSyncTask(() -> level.m_7967_((Entity)entity.asMob()));
            if (!added) {
                throw new IllegalArgumentException("Unable to spawn horse entity");
            }
        }
    }

    private void hideMainNpcForPlayer(NPC npc, ECPlayer player) {
        Optional<ECNpc> main = this.npcEntityCache.findMainNpc(npc.getId());
        main.ifPresent(n -> n.hideGlobalFromPlayer(player));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetNPCsForPlayer(ECPlayer player) {
        List<NPC> npcs = this.npcRepository.findAllEnabled();
        Object object = this.npcResetLock;
        synchronized (object) {
            for (NPC npc : npcs) {
                this.destroyPlayerPrivateNPC(npc, player);
                this.showMainNpcForPlayer(npc, player);
            }
        }
    }

    private void destroyPlayerPrivateNPC(NPC npc, ECPlayer player) {
        Optional<ECNpc> privateNpc = this.npcEntityCache.findPrivateNpcForPlayer(npc.getId(), player.getAccountUuid());
        if (privateNpc.isPresent()) {
            Mob mob = privateNpc.get().asMob();
            TaskScheduler.executeSyncTask(() -> {
                if (!mob.m_146910_()) {
                    mob.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            });
            this.npcEntityCache.removePlayerPrivateEntityForNpc(privateNpc.get().getInternalId(), player.getAccountUuid());
        }
    }

    private void showMainNpcForPlayer(NPC npc, ECPlayer player) {
        Optional<ECNpc> mainNpc = this.npcEntityCache.findMainNpc(npc.getId());
        mainNpc.ifPresent(n -> n.showGlobalToPlayer(player));
    }

    @Override
    public void deSpawnNPC(ECNpc entityNPC) {
        if (entityNPC != null) {
            Mob mob = entityNPC.asMob();
            if (!mob.m_146910_()) {
                mob.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            this.npcEntityCache.removeEntityForNpc(entityNPC.getInternalId());
        } else {
            log.info("Attempted to despawn an NPC which has not yet been created");
        }
    }

    @Override
    public void refreshAllNPCs() {
        log.info("Refreshing all NPCs");
        this.refreshNPCChunkCache();
        ListMap<UUID, PrivatePlayerNpcInfo> playerNpcsToReset = this.despawnAllNpcs();
        this.spawnAllNPCs();
        this.resetPlayerNpcs(playerNpcsToReset);
    }

    private ListMap<UUID, PrivatePlayerNpcInfo> despawnAllNpcs() {
        log.info("Despawning NPCs");
        ListMap<UUID, PrivatePlayerNpcInfo> playerNpcsToReset = new ListMap<UUID, PrivatePlayerNpcInfo>();
        for (ServerLevel level : ServerLevelUtil.getServerLevels()) {
            for (ECNpc entity : level.m_143280_(EntityTypeTest.m_156916_(EntityNPC.class), PredicateUtils.truePredicate())) {
                if (entity.isPrivateForPlayer()) {
                    DirectionalCoordinate coordinate = new DirectionalCoordinate(entity.m_20182_().m_7096_(), entity.m_20182_().m_7098_(), entity.m_20182_().m_7094_(), ServerLevelUtil.getEntitiesServerLevelIdentifier((Entity)entity), entity.m_146908_(), entity.m_146909_());
                    PrivatePlayerNpcInfo info2 = new PrivatePlayerNpcInfo(((EntityNPC)entity).getInternalId(), coordinate);
                    playerNpcsToReset.add(entity.getPrivatePlayerUuid(), info2);
                }
                this.deSpawnNPC(entity);
            }
            for (ECNpc entity : level.m_143280_(EntityTypeTest.m_156916_(EntityHorse.class), e -> e.getHorseEntityType() == HorseEntityType.NPC)) {
                this.deSpawnNPC(entity);
            }
        }
        return playerNpcsToReset;
    }

    private void spawnAllNPCs() {
        log.info("Spawning all NPCs");
        for (NPC npc : this.npcRepository.findAllEnabled()) {
            this.spawnMainNPC(npc);
        }
    }

    private void resetPlayerNpcs(ListMap<UUID, PrivatePlayerNpcInfo> playerNpcsToReset) {
        log.info("Resetting player NPCs");
        for (UUID playerUuid : playerNpcsToReset.getAllKeys()) {
            List<PrivatePlayerNpcInfo> npcInfoList = playerNpcsToReset.get(playerUuid);
            for (PrivatePlayerNpcInfo npcInfo : npcInfoList) {
                NPC npc = (NPC)this.npcRepository.findByKey(npcInfo.internalId());
                CorePlayer player = this.playerRepository.findPlayerByAccountUuid(playerUuid).orElseThrow();
                this.spawnPlayerOnlyNPC(npc, player, npcInfo.location());
            }
        }
    }

    @Override
    public void refreshNPCChunkCache() {
        log.info("Refreshing NPC chunk cache");
        this.npcEntityCache.reloadCache();
    }

    @Override
    public void setWaypointForNpc(NPC npc, ECPlayer player, Coordinate waypoint, double speed, Runnable onReachAction, Integer minimumDistance, Runnable minimumDistanceInitialAction, Duration minimumDistanceDuration, Runnable onMinimumDistanceAction, Integer maximumDistance, Runnable maximumDistanceInitialAction, Duration maximumDistanceDuration, Runnable onMaximumDistanceAction) {
        Optional<ECNpc> entityNpc = this.npcEntityCache.findPrivateNpcForPlayer(npc.getId(), player.getAccountUuid());
        if (entityNpc.isPresent()) {
            MobWaypointFollowGoal goal;
            Mob mob = entityNpc.get().asMob();
            try {
                goal = GoalUtil.findGoal(mob, MobWaypointFollowGoal.class);
            }
            catch (NoSuchElementException ex) {
                goal = GoalUtil.findGoal(mob, HorseWaypointFollowGoal.class);
            }
            OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
            MobWaypointDistancePolicy minimumDistancePolicy = minimumDistance != null ? new MobWaypointDistancePolicy(minimumDistance, minimumDistanceInitialAction, minimumDistanceDuration, onMinimumDistanceAction) : null;
            MobWaypointDistancePolicy maximumDistancePolicy = maximumDistance != null ? new MobWaypointDistancePolicy(maximumDistance, maximumDistanceInitialAction, maximumDistanceDuration, onMaximumDistanceAction) : null;
            goal.setPlayer(onlinePlayer, minimumDistancePolicy, maximumDistancePolicy);
            goal.setWaypoint(new Vec3(waypoint.x(), waypoint.y(), waypoint.z()), speed, onReachAction);
        }
    }

    @Override
    public void setNpcFollowPlayer(NPC npc, ECPlayer player, double speed) {
        Optional<ECNpc> entityNpc = this.npcEntityCache.findPrivateNpcForPlayer(npc.getId(), player.getAccountUuid());
        if (entityNpc.isPresent()) {
            Mob mob = entityNpc.get().asMob();
            NpcFollowPlayerGoal goal = GoalUtil.findGoal(mob, NpcFollowPlayerGoal.class);
            OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
            goal.setFollow(onlinePlayer.serverPlayer(), speed);
            entityNpc.get().setBaseSpeed(0.5f);
        }
    }

    @Override
    public void stopNpcFollowPlayer(NPC npc, ECPlayer player) {
        Optional<ECNpc> entityNpc = this.npcEntityCache.findPrivateNpcForPlayer(npc.getId(), player.getAccountUuid());
        if (entityNpc.isPresent()) {
            Mob mob = entityNpc.get().asMob();
            NpcFollowPlayerGoal goal = GoalUtil.findGoal(mob, NpcFollowPlayerGoal.class);
            goal.m_8041_();
        }
    }

    private record PrivatePlayerNpcInfo(int internalId, DirectionalCoordinate location) {
    }
}

