/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.npc;

import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.mod.client.ECNpc;
import com.equestricraft.mod.util.ChunkPosUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.level.ChunkPos;

public final class NpcCacheEntry {
    private final int id;
    private final NPC npc;
    private ECNpc mainEntity = null;
    private ECLevel mainEntityLevel;
    private ChunkPos mainEntityChunk;
    private final Map<UUID, ECNpc> playerPrivateEntities = new HashMap<UUID, ECNpc>();

    NpcCacheEntry(NPC npc) {
        this.id = npc.getId();
        this.npc = npc;
        DirectionalCoordinate location = npc.getLocation();
        this.mainEntityLevel = ECLevel.getByIdentifier(location.world());
        this.mainEntityChunk = ChunkPosUtil.toChunkPos(location);
    }

    public int getId() {
        return this.id;
    }

    public NPC getNpc() {
        return this.npc;
    }

    public ECNpc getMainEntity() {
        return this.mainEntity;
    }

    public void setMainEntity(ECNpc mainEntity) {
        this.mainEntity = mainEntity;
    }

    public ECLevel getMainEntityLevel() {
        return this.mainEntityLevel;
    }

    public void setMainEntityLevel(ECLevel mainEntityLevel) {
        this.mainEntityLevel = mainEntityLevel;
    }

    public ChunkPos getMainEntityChunk() {
        return this.mainEntityChunk;
    }

    public void setMainEntityChunk(ChunkPos mainEntityChunk) {
        this.mainEntityChunk = mainEntityChunk;
    }

    public Map<UUID, ECNpc> getPlayerPrivateEntities() {
        return this.playerPrivateEntities;
    }

    public boolean active() {
        return this.mainEntity != null;
    }

    public void removeEntity() {
        this.mainEntity = null;
    }
}

