/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.npc;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.npc.NPC;
import com.equestricraft.core.npc.NPCRepository;
import com.equestricraft.mod.client.ECNpc;
import com.equestricraft.mod.npc.NpcCacheEntry;
import com.equestricraft.mod.util.ChunkPosUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.world.level.ChunkPos;

public final class NpcEntityCache {
    private static final NpcEntityCache instance = new NpcEntityCache();
    private final DataStructure dataStructure = new DataStructure();
    private final StampedLock lock = new StampedLock();
    @Service
    private static NPCRepository npcRepository;

    public static NpcEntityCache getInstance() {
        return instance;
    }

    private NpcEntityCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCache() {
        long stamp = this.lock.writeLock();
        try {
            List<NPC> npcs = npcRepository.findAllEnabled();
            for (NPC npc : npcs) {
                Optional<NpcCacheEntry> entry = this.dataStructure.findById(npc.getId());
                if (entry.isPresent()) {
                    NpcCacheEntry e = entry.get();
                    DirectionalCoordinate location = npc.getLocation();
                    ECLevel level = ECLevel.getByIdentifier(location.world());
                    e.setMainEntityLevel(level);
                    e.setMainEntityChunk(ChunkPosUtil.toChunkPos(location));
                    continue;
                }
                NpcCacheEntry newEntry = new NpcCacheEntry(npc);
                this.dataStructure.add(newEntry);
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public void add(ECNpc entityNPC) {
        if (entityNPC.isPrivateForPlayer()) {
            this.addPlayerPrivateEntity(entityNPC.getPrivatePlayerUuid(), entityNPC);
        } else {
            this.addMainEntity(entityNPC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMainEntity(ECNpc entityNPC) {
        long stamp = this.lock.writeLock();
        try {
            this.dataStructure.findById(entityNPC.getInternalId()).ifPresent(e -> e.setMainEntity(entityNPC));
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPlayerPrivateEntity(UUID playerUuid, ECNpc entityNPC) {
        long stamp = this.lock.writeLock();
        try {
            this.dataStructure.findById(entityNPC.getInternalId()).ifPresent(e -> e.getPlayerPrivateEntities().put(playerUuid, entityNPC));
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NPC> findMainEntitiesInChunk(ECLevel leve, ChunkPos chunk) {
        long stamp = this.lock.readLock();
        try {
            List<NPC> list = this.dataStructure.findAllInDimensionChunk(leve, chunk).stream().map(NpcCacheEntry::getNpc).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ECNpc> findMainNpc(int npcId) {
        long stamp = this.lock.readLock();
        try {
            Optional<ECNpc> optional = this.dataStructure.findById(npcId).map(NpcCacheEntry::getMainEntity);
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ECNpc> findPrivateNpcForPlayer(int npcId, UUID playerUuid) {
        long stamp = this.lock.readLock();
        try {
            Optional<ECNpc> optional = this.dataStructure.findById(npcId).map(NpcCacheEntry::getPlayerPrivateEntities).map(m -> (ECNpc)m.get(playerUuid));
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNpcActive(int id) {
        long stamp = this.lock.readLock();
        try {
            Optional<NpcCacheEntry> npc = this.dataStructure.findById(id);
            boolean bl = npc.filter(NpcCacheEntry::active).isPresent();
            return bl;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntityForNpc(int id) {
        long stamp = this.lock.writeLock();
        try {
            Optional<NpcCacheEntry> n = this.dataStructure.findById(id);
            n.ifPresent(NpcCacheEntry::removeEntity);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayerPrivateEntityForNpc(int npcId, UUID playerUuid) {
        long stamp = this.lock.writeLock();
        try {
            Optional<NpcCacheEntry> n = this.dataStructure.findById(npcId);
            n.ifPresent(e -> e.getPlayerPrivateEntities().remove(playerUuid));
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    private static class DataStructure {
        private final List<NpcCacheEntry> entries = new ArrayList<NpcCacheEntry>(0);
        private final Map<Integer, NpcCacheEntry> idMap = new HashMap<Integer, NpcCacheEntry>();

        private DataStructure() {
        }

        public void add(NpcCacheEntry entry) {
            if (this.entries.stream().noneMatch(e -> e.getId() == entry.getId())) {
                this.entries.add(entry);
            }
            this.idMap.put(entry.getId(), entry);
        }

        public Optional<NpcCacheEntry> findById(int id) {
            return Optional.ofNullable(this.idMap.get(id));
        }

        public List<NpcCacheEntry> findAllInDimensionChunk(ECLevel level, ChunkPos chunk) {
            return this.entries.stream().filter(e -> e.getMainEntityLevel() != null && e.getMainEntityLevel() == level).filter(e -> e.getMainEntityChunk() != null && e.getMainEntityChunk().equals((Object)chunk)).toList();
        }
    }
}

