/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.operation;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.operation.OperationPlayer;
import com.equestricraft.mod.client.item.OperationTool;
import com.equestricraft.mod.horse.PlayerInteractHorseEvent;
import com.equestricraft.mod.operation.OperationService;
import com.equestricraft.mod.player.ECPlayerJoinEvent;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class OperationListener {
    @Service
    private static OperationService operationService;

    @SubscribeEvent
    public static void onOperationTool(PlayerInteractHorseEvent event) {
        ItemStack item = event.getItemInHand();
        if (item.m_41720_() instanceof OperationTool) {
            CompoundTag itemData = item.m_41783_();
            Objects.requireNonNull(itemData, "Operation tool does not appear to have any operation linked");
            int operationId = itemData.m_128451_("operationId");
            TaskScheduler.executeAsyncTask(() -> {
                Response continueResponse = operationService.continueOperation(event.getPlayer(), event.getHorse().getId());
                if (!continueResponse.isSuccess()) {
                    Response response = operationService.startOperation(event.getPlayer(), operationId, event.getHorse().getId());
                    event.getPlayer().showResponse(response);
                } else {
                    event.getPlayer().showResponse(continueResponse);
                }
            });
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(ECPlayerJoinEvent event) {
        OnlinePlayer player = event.getPlayer();
        OperationPlayer operationPlayer = new OperationPlayer(player.getCorePlayer());
        player.provideData(operationPlayer);
    }

    private OperationListener() {
    }
}

