/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.operation;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationConfirmationHandler;
import com.equestricraft.core.operation.OperationPageService;
import com.equestricraft.core.operation.OperationPerformException;
import com.equestricraft.core.operation.OperationPerformSession;
import com.equestricraft.core.operation.OperationPlayer;
import com.equestricraft.core.operation.OperationRepository;
import com.equestricraft.core.operation.OperationToolPage;
import com.equestricraft.core.operation.OwnerConfirmationNeededException;
import com.equestricraft.core.operation.PerformOperationResponse;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.confirmation.ConfirmResponse;
import com.equestricraft.groovy.GroovyPromptNeededException;
import com.equestricraft.mod.client.item.OperationToolItemCache;
import com.equestricraft.mod.groovy.prompt.GroovyPromptService;
import com.equestricraft.mod.operation.OperationService;
import com.equestricraft.mod.packet.ClientBoundOperationToolboxPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ComponentUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class OperationServiceImpl
implements OperationService {
    @Service
    private OperationPageService operationPageService;
    @Service
    private OperationPerformSession operationPerformSession;
    @Service
    private OperationRepository operationRepository;
    @Service
    private HorseRepository horseRepository;
    @Service
    private GroovyPromptService groovyPromptService;
    private final OperationConfirmationHandler operationConfirmationHandler = OperationConfirmationHandler.getInstance();
    private final OperationToolItemCache operationToolItemCache = OperationToolItemCache.getInstance();

    @Override
    public Response showToolboxMenu(OnlinePlayer onlinePlayer) {
        return this.showToolboxMenu(onlinePlayer, 1);
    }

    @Override
    public Response showToolboxMenu(OnlinePlayer onlinePlayer, int pageNumber) {
        OperationToolPage operations = this.operationPageService.retrieveOperationToolPage(onlinePlayer, pageNumber);
        ClientBoundOperationToolboxPacket packet = new ClientBoundOperationToolboxPacket(operations);
        onlinePlayer.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response giveToolToPlayer(ServerPlayer player, int operationId) {
        Operation operation = (Operation)this.operationRepository.findByKey(operationId);
        ItemStack toolItem = new ItemStack((ItemLike)this.operationToolItemCache.get(operation.getModel()));
        CompoundTag itemData = new CompoundTag();
        itemData.m_128405_("operationId", operationId);
        toolItem.m_41751_(itemData);
        toolItem.m_41714_((Component)ComponentUtil.buildColoredTextComponent(operation.getName()));
        boolean added = player.m_150109_().m_36054_(toolItem);
        if (added) {
            return ResponseFactory.success(I18n.getLabel("operation.give-tool.tool-given", operation.getName()));
        }
        return ResponseFactory.success(I18n.getLabel("operation.give-tool.not-enough-space"));
    }

    @Override
    public Response startOperation(ECPlayer player, int operationId, int horseId) {
        Operation operation = (Operation)this.operationRepository.findByKey(operationId);
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        if (operation.isRequireWorkStart() && horse.getOwnerId() != player.getId() && !player.getJob().getWork().hasActiveWork()) {
            return ResponseFactory.fail(I18n.getLabel("operation.no-active-work"));
        }
        OperationPlayer operationPlayer = player.require(OperationPlayer.class);
        try {
            PerformOperationResponse response = this.operationPerformSession.performHorseInteract(operationPlayer, operation, horse);
            for (String message : response.playerMessages()) {
                player.showResponse(ResponseFactory.success(response.operation().getName(), message));
            }
            for (String message : response.ownerMessages()) {
                horse.getOwner().showResponse(ResponseFactory.success(response.operation().getName(), message));
            }
            return ResponseFactory.success();
        }
        catch (OperationPerformException ex) {
            operationPlayer.reset();
            return ResponseFactory.fail(ex.getTitle(), ex.getMessage());
        }
        catch (GroovyPromptNeededException ex) {
            this.groovyPromptService.processPromptRequests(player, ex.getRequest());
            return this.startOperation(player, operationId, horseId);
        }
        catch (OwnerConfirmationNeededException ex) {
            return this.handleConformation(player, operation, horse);
        }
    }

    private Response handleConformation(ECPlayer player, Operation operation, EQHorse horse) {
        ECPlayer owner = horse.getOwner();
        if (owner.isOnline()) {
            player.sendMessage(I18n.getLabel("operation.owner-confirmation-needed"));
            ConfirmResponse response = horse.getOwner().getConfirmation().confirm(I18n.getLabel("operation.confirm.title"), I18n.getLabel("operation.confirm.message", operation.getName(), horse.getName()));
            if (response.isYes()) {
                this.operationConfirmationHandler.addConfirmation(owner.getId(), operation.getId(), horse.getId(), player.getId());
                return this.startOperation(player, operation.getId(), horse.getId());
            }
            this.cancelOperation(player);
            return ResponseFactory.fail(I18n.getLabel("operation.not-performed.prompt.title"), I18n.getLabel("operation.owner-did-not-confirm"));
        }
        this.cancelOperation(player);
        return ResponseFactory.fail(I18n.getLabel("operation.not-performed.prompt.title"), I18n.getLabel("operation.owner-not-online"));
    }

    @Override
    public Response continueOperation(ECPlayer player, int horseId) {
        OperationPlayer operationPlayer = player.require(OperationPlayer.class);
        if (operationPlayer.isActiveOperation()) {
            return this.startOperation(player, operationPlayer.getOperation().getId(), horseId);
        }
        return ResponseFactory.fail();
    }

    @Override
    public Response cancelOperation(ECPlayer player) {
        this.operationPerformSession.cancelOperation(player);
        return ResponseFactory.success(I18n.getLabel("operation.cancelled"));
    }
}

