/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.models.ModelHorseAnimation;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundAnimationSpeedFactorUpdatePacket {
    private final Map<String, Float> speedFactorsMap;

    public ClientBoundAnimationSpeedFactorUpdatePacket(Map<String, Float> speedFactorsMap) {
        this.speedFactorsMap = speedFactorsMap;
    }

    public Map<String, Float> getSpeedFactorsMap() {
        return this.speedFactorsMap;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.speedFactorsMap.size());
        for (Map.Entry<String, Float> entry : this.speedFactorsMap.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeFloat(entry.getValue().floatValue());
        }
    }

    public static ClientBoundAnimationSpeedFactorUpdatePacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, Float> map = new HashMap<String, Float>(size);
        for (int i = 0; i < size; ++i) {
            String name = buffer.m_130277_();
            float value = buffer.readFloat();
            map.put(name, Float.valueOf(value));
        }
        return new ClientBoundAnimationSpeedFactorUpdatePacket(map);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ModelHorseAnimation.processUpdates(this));
    }
}

