/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.economy.transaction.BankAccountTransactionInfo;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.bank.BankAccountTransactionScreen;
import com.equestricraft.mod.economy.BankAccountTransactionPage;
import com.equestricraft.mod.economy.BankAccountTransactionSortOrder;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundBankAccountTransactionListOpenPacket {
    private final int accountId;
    private final String accountName;
    private final BankAccountTransactionPage page;

    public ClientBoundBankAccountTransactionListOpenPacket(int accountId, String accountName, BankAccountTransactionPage page) {
        this.accountId = accountId;
        this.accountName = accountName;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.accountId);
        buffer.m_130070_(this.accountName);
        buffer.writeInt(this.page.getItems().size());
        for (BankAccountTransactionInfo item : this.page.getItems()) {
            buffer.writeInt(item.id());
            buffer.writeLong(item.timeStamp());
            buffer.writeDouble(item.amount());
            buffer.m_130070_(item.amountFormatted());
            if (item.otherPlayer() != null) {
                buffer.writeBoolean(true);
                PlayerSerializer.serializePlayerSimple(item.otherPlayer(), buffer);
            } else {
                buffer.writeBoolean(false);
            }
            if (item.otherAccountId() != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(item.otherAccountId().intValue());
            } else {
                buffer.writeBoolean(false);
            }
            if (item.otherAccountName() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(item.otherAccountName());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130070_(item.reason());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.m_130068_((Enum)this.page.getSortOrder());
        buffer.m_130070_((String)this.page.getFilterObject());
    }

    public static ClientBoundBankAccountTransactionListOpenPacket decode(FriendlyByteBuf buffer) {
        int accountId = buffer.readInt();
        String accountName = buffer.m_130277_();
        int itemsCount = buffer.readInt();
        ArrayList<BankAccountTransactionInfo> items = new ArrayList<BankAccountTransactionInfo>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            int id = buffer.readInt();
            long timeStamp = buffer.readLong();
            double amount = buffer.readDouble();
            String amountFormatted = buffer.m_130277_();
            PlayerSimple otherPlayer = buffer.readBoolean() ? PlayerSerializer.deserializePlayerSimple(buffer) : null;
            Integer otherAccountId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
            String otherAccountName = buffer.readBoolean() ? buffer.m_130277_() : null;
            String reason = buffer.m_130277_();
            BankAccountTransactionInfo item = new BankAccountTransactionInfo(id, timeStamp, amount, amountFormatted, otherPlayer, otherAccountId, otherAccountName, reason);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        BankAccountTransactionSortOrder sortOrder = (BankAccountTransactionSortOrder)buffer.m_130066_(BankAccountTransactionSortOrder.class);
        String filterObject = buffer.m_130277_();
        BankAccountTransactionPage page = new BankAccountTransactionPage(items, pageNumber, totalPages, sortDirection, sortOrder, filterObject);
        return new ClientBoundBankAccountTransactionListOpenPacket(accountId, accountName, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> BankAccountTransactionScreen.showScreen(this.accountId, this.accountName, this.page));
    }
}

