/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.BankAccountType;
import com.equestricraft.core.economy.account.BankAccountInfo;
import com.equestricraft.mod.client.gui.bank.BankAccountMenuScreen;
import com.equestricraft.mod.economy.BankAccountPage;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundBankAccountsListOpenPacket {
    private final BankAccountPage page;

    public ClientBoundBankAccountsListOpenPacket(BankAccountPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (BankAccountInfo item : this.page.getItems()) {
            buffer.writeInt(item.accountId());
            buffer.m_130070_(item.accountName());
            buffer.m_130068_((Enum)item.type());
            buffer.writeDouble(item.balance());
            buffer.m_130070_(item.balanceFormatted());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundBankAccountsListOpenPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<BankAccountInfo> accounts = new ArrayList<BankAccountInfo>(count);
        for (int i = 0; i < count; ++i) {
            int accountId = buffer.readInt();
            String accountName = buffer.m_130277_();
            BankAccountType type = (BankAccountType)buffer.m_130066_(BankAccountType.class);
            double balance = buffer.readDouble();
            String balanceFormatted = buffer.m_130277_();
            BankAccountInfo account = new BankAccountInfo(accountId, accountName, type, balance, balanceFormatted);
            accounts.add(account);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        BankAccountPage page = new BankAccountPage((List<BankAccountInfo>)accounts, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundBankAccountsListOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> BankAccountMenuScreen.showScreen(this.page));
    }
}

