/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.breed.BreedInfo;
import com.equestricraft.mod.client.gui.BreedInfoScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundBreedInfoOpenPacket {
    private final BreedInfo breedInfo;

    public ClientBoundBreedInfoOpenPacket(BreedInfo breedInfo) {
        this.breedInfo = breedInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.breedInfo.breedId());
        buffer.m_130070_(this.breedInfo.breedName());
        buffer.m_130070_(this.breedInfo.description());
    }

    public static ClientBoundBreedInfoOpenPacket decode(FriendlyByteBuf buffer) {
        int breedId = buffer.readInt();
        String breedName = buffer.m_130277_();
        String description = buffer.m_130277_();
        BreedInfo breedInfo = new BreedInfo(breedId, breedName, description);
        return new ClientBoundBreedInfoOpenPacket(breedInfo);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> BreedInfoScreen.showScreen(this.breedInfo));
    }
}

