/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.business.BusinessListItem;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.business.BusinessSelectAction;
import com.equestricraft.mod.client.gui.business.BusinessItemScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundBusinessItemListPacket {
    private final List<BusinessListItem> businessListItems;
    private final BusinessSelectAction action;

    public ClientBoundBusinessItemListPacket(List<BusinessListItem> businessListItems, BusinessSelectAction action) {
        this.businessListItems = businessListItems;
        this.action = action;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.writeInt(this.businessListItems.size());
        for (BusinessListItem item : this.businessListItems) {
            buffer.writeInt(item.businessId());
            buffer.m_130070_(item.businessName());
            PlayerSerializer.serializePlayerSimple(item.owner(), buffer);
        }
    }

    public static ClientBoundBusinessItemListPacket decode(FriendlyByteBuf buffer) {
        BusinessSelectAction action = (BusinessSelectAction)buffer.m_130066_(BusinessSelectAction.class);
        int amount = buffer.readInt();
        ArrayList<BusinessListItem> items = new ArrayList<BusinessListItem>(amount);
        for (int i = 0; i < amount; ++i) {
            int businessId = buffer.readInt();
            String businessName = buffer.m_130277_();
            PlayerSimple owner = PlayerSerializer.deserializePlayerSimple(buffer);
            items.add(new BusinessListItem(businessId, businessName, owner));
        }
        return new ClientBoundBusinessItemListPacket(items, action);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> BusinessItemScreen.showScreen(this.businessListItems, this.action));
    }
}

