/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.business.BusinessCategoryDto;
import com.equestricraft.mod.client.gui.business.RegisterBusinessMenu;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundBusinessRegisterBusinessMenuOpenPacket {
    private final List<BusinessCategoryDto> categories;

    public ClientBoundBusinessRegisterBusinessMenuOpenPacket(List<BusinessCategoryDto> categories) {
        this.categories = categories;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.categories.size());
        for (BusinessCategoryDto category : this.categories) {
            buffer.writeInt(category.id());
            buffer.m_130070_(category.name());
            buffer.m_130070_(category.description());
        }
    }

    public static ClientBoundBusinessRegisterBusinessMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int categoriesCount = buffer.readInt();
        ArrayList<BusinessCategoryDto> categories = new ArrayList<BusinessCategoryDto>(categoriesCount);
        for (int i = 0; i < categoriesCount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            BusinessCategoryDto category = new BusinessCategoryDto(id, name, description);
            categories.add(category);
        }
        return new ClientBoundBusinessRegisterBusinessMenuOpenPacket(categories);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> RegisterBusinessMenu.showScreen(this.categories));
    }
}

