/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.business.BusinessPublicRegisterPage;
import com.equestricraft.mod.business.BusinessSerializer;
import com.equestricraft.mod.client.gui.business.BusinessPublicRegisterMenuScreen;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.packet.ServerBoundBusinessSearchSelectPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundBusinessSearchMenuOpenPacket {
    private final UUID uuid;
    private final BusinessPublicRegisterPage page;

    public ClientBoundBusinessSearchMenuOpenPacket(UUID uuid, BusinessPublicRegisterPage page) {
        this.uuid = uuid;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        BusinessSerializer.serialize(this.page, buffer);
    }

    public static ClientBoundBusinessSearchMenuOpenPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        BusinessPublicRegisterPage page = BusinessSerializer.deserialize(buffer);
        return new ClientBoundBusinessSearchMenuOpenPacket(uuid, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> BusinessPublicRegisterMenuScreen.showScreen(this.page, this.uuid, item -> {
            ServerBoundBusinessSearchSelectPacket packet = new ServerBoundBusinessSearchSelectPacket(this.uuid, item.businessId());
            Network.sendToServer(packet);
        }));
    }
}

