/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.mod.chattag.ChatTagItem;
import com.equestricraft.mod.chattag.ChatTagPage;
import com.equestricraft.mod.client.gui.chattag.ChatTagMenu;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundChatTagMenuOpenPacket {
    private final ChatTagPage page;

    public ClientBoundChatTagMenuOpenPacket(ChatTagPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (ChatTagItem item : this.page.getItems()) {
            buffer.writeInt(item.id());
            buffer.m_130070_(item.name());
            buffer.m_130070_(item.description());
            buffer.m_130070_(item.tag());
            buffer.writeBoolean(item.isActive());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundChatTagMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<ChatTagItem> items = new ArrayList<ChatTagItem>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            String tag = buffer.m_130277_();
            boolean active = buffer.readBoolean();
            ChatTagItem item = new ChatTagItem(id, name, description, tag, active);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        ChatTagPage page = new ChatTagPage(items, pageNumber, totalPages, SortDirection.ASCENDING);
        return new ClientBoundChatTagMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ChatTagMenu.showScreen(this.page));
    }
}

