/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.ClubJoinRequestStatus;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestClubInfo;
import com.equestricraft.mod.client.gui.club.ClubInvitesMenuScreen;
import com.equestricraft.mod.club.ClubJoinInvitePage;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundClubJoinInvitePageOpenPacket {
    private final ClubJoinInvitePage page;

    public ClientBoundClubJoinInvitePageOpenPacket(ClubJoinInvitePage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (ClubJoinRequestClubInfo item : this.page.getItems()) {
            buffer.writeInt(item.clubId());
            buffer.m_130070_(item.clubName());
            buffer.writeInt(item.hoursSince());
            buffer.m_130070_(item.message());
            buffer.m_130068_((Enum)item.status());
            buffer.m_130070_(item.statusMessage());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundClubJoinInvitePageOpenPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<ClubJoinRequestClubInfo> items = new ArrayList<ClubJoinRequestClubInfo>(count);
        for (int i = 0; i < count; ++i) {
            int clubId = buffer.readInt();
            String clubName = buffer.m_130277_();
            int hoursSince = buffer.readInt();
            String message = buffer.m_130277_();
            ClubJoinRequestStatus status = (ClubJoinRequestStatus)buffer.m_130066_(ClubJoinRequestStatus.class);
            String statusMessage = buffer.m_130277_();
            ClubJoinRequestClubInfo item = new ClubJoinRequestClubInfo(clubId, clubName, hoursSince, message, status, statusMessage);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        ClubJoinInvitePage page = new ClubJoinInvitePage((List<ClubJoinRequestClubInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundClubJoinInvitePageOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClubInvitesMenuScreen.showScreen(this.page));
    }
}

