/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.club.joinrequest.ClubJoinRequestPlayerInfo;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.club.ClubJoinRequestPageScreen;
import com.equestricraft.mod.club.ClubJoinRequestPage;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundClubJoinRequestPageOpenPacket {
    private final int clubId;
    private final ClubJoinRequestPage page;

    public ClientBoundClubJoinRequestPageOpenPacket(int clubId, ClubJoinRequestPage page) {
        this.clubId = clubId;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clubId);
        buffer.writeInt(this.page.getItems().size());
        for (ClubJoinRequestPlayerInfo item : this.page.getItems()) {
            PlayerSerializer.serializePlayerSimple(item.player(), buffer);
            buffer.writeInt(item.hoursSince());
            buffer.m_130070_(item.message());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundClubJoinRequestPageOpenPacket decode(FriendlyByteBuf buffer) {
        int clubId = buffer.readInt();
        int count = buffer.readInt();
        ArrayList<ClubJoinRequestPlayerInfo> items = new ArrayList<ClubJoinRequestPlayerInfo>(count);
        for (int i = 0; i < count; ++i) {
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            int hoursSince = buffer.readInt();
            String message = buffer.m_130277_();
            ClubJoinRequestPlayerInfo item = new ClubJoinRequestPlayerInfo(player, hoursSince, message);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        ClubJoinRequestPage page = new ClubJoinRequestPage((List<ClubJoinRequestPlayerInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundClubJoinRequestPageOpenPacket(clubId, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClubJoinRequestPageScreen.showScreen(this.clubId, this.page));
    }
}

