/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.club.member.ClubMemberInfo;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.club.ClubMemberPageScreen;
import com.equestricraft.mod.club.ClubMemberPage;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundClubMemberPageOpenPacket {
    private final int clubId;
    private final ClubMemberPage clubMemberPage;

    public ClientBoundClubMemberPageOpenPacket(int clubId, ClubMemberPage clubMemberPage) {
        this.clubId = clubId;
        this.clubMemberPage = clubMemberPage;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clubId);
        buffer.writeInt(this.clubMemberPage.getItems().size());
        for (ClubMemberInfo item : this.clubMemberPage.getItems()) {
            PlayerSerializer.serializePlayerSimple(item.player(), buffer);
            if (item.rankId() != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(item.rankId().intValue());
            } else {
                buffer.writeBoolean(false);
            }
            if (item.rankName() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(item.rankName());
            } else {
                buffer.writeBoolean(false);
            }
            if (item.permissionLevel() != null) {
                buffer.writeBoolean(true);
                buffer.m_130068_((Enum)item.permissionLevel());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.m_130075_(item.since());
            buffer.writeBoolean(item.owner());
        }
        buffer.writeInt(this.clubMemberPage.getPageNumber());
        buffer.writeInt(this.clubMemberPage.getTotalPages());
        buffer.m_130068_((Enum)this.clubMemberPage.getSortDirection());
    }

    public static ClientBoundClubMemberPageOpenPacket decode(FriendlyByteBuf buffer) {
        int clubId = buffer.readInt();
        int count = buffer.readInt();
        ArrayList<ClubMemberInfo> items = new ArrayList<ClubMemberInfo>(count);
        for (int i = 0; i < count; ++i) {
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            Integer rankId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
            String rankName = buffer.readBoolean() ? buffer.m_130277_() : null;
            ClubPermissionLevel level = buffer.readBoolean() ? (ClubPermissionLevel)buffer.m_130066_(ClubPermissionLevel.class) : null;
            Date since = buffer.m_130282_();
            boolean owner = buffer.readBoolean();
            ClubMemberInfo item = new ClubMemberInfo(player, rankId, rankName, level, since, owner);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        ClubMemberPage page = new ClubMemberPage((List<ClubMemberInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundClubMemberPageOpenPacket(clubId, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClubMemberPageScreen.showScreen(this.clubId, this.clubMemberPage));
    }
}

