/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.club.ClubInfo;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.club.ClubPageScreen;
import com.equestricraft.mod.club.ClubPage;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundClubPageOpenMenuPacket {
    private final ClubPage clubPage;

    public ClientBoundClubPageOpenMenuPacket(ClubPage clubPage) {
        this.clubPage = clubPage;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clubPage.getItems().size());
        for (ClubInfo item : this.clubPage.getItems()) {
            buffer.writeInt(item.clubId());
            buffer.m_130070_(item.clubName());
            PlayerSerializer.serializePlayerSimple(item.owner(), buffer);
            buffer.m_130075_(item.startedDate());
            buffer.writeInt(item.memberCount());
            buffer.writeBoolean(item.canSendJoinRequest());
        }
        buffer.writeInt(this.clubPage.getPageNumber());
        buffer.writeInt(this.clubPage.getTotalPages());
        buffer.m_130068_((Enum)this.clubPage.getSortDirection());
    }

    public static ClientBoundClubPageOpenMenuPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<ClubInfo> items = new ArrayList<ClubInfo>(count);
        for (int i = 0; i < count; ++i) {
            int clubId = buffer.readInt();
            String name = buffer.m_130277_();
            PlayerSimple owner = PlayerSerializer.deserializePlayerSimple(buffer);
            Date startedDate = buffer.m_130282_();
            int memberCount = buffer.readInt();
            boolean canJoinRequestBeSent = buffer.readBoolean();
            ClubInfo item = new ClubInfo(clubId, name, owner, startedDate, memberCount, canJoinRequestBeSent);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        ClubPage page = new ClubPage((List<ClubInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundClubPageOpenMenuPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClubPageScreen.showScreen(this.clubPage));
    }
}

