/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.club.rank.ClubPermissionLevel;
import com.equestricraft.core.club.rank.ClubRankInfo;
import com.equestricraft.mod.client.gui.club.ClubRankPageScreen;
import com.equestricraft.mod.club.ClubRankPage;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundClubRankPageScreenOpenPacket {
    private final int clubId;
    private final ClubRankPage page;

    public ClientBoundClubRankPageScreenOpenPacket(int clubId, ClubRankPage page) {
        this.clubId = clubId;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.clubId);
        buffer.writeInt(this.page.getItems().size());
        for (ClubRankInfo item : this.page.getItems()) {
            buffer.writeInt(item.rankId());
            buffer.m_130070_(item.rankName());
            buffer.m_130068_((Enum)item.permissionLevel());
            buffer.writeBoolean(item.defaultRank());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundClubRankPageScreenOpenPacket decode(FriendlyByteBuf buffer) {
        int clubId = buffer.readInt();
        int count = buffer.readInt();
        ArrayList<ClubRankInfo> ranks = new ArrayList<ClubRankInfo>(count);
        for (int i = 0; i < count; ++i) {
            int rankId = buffer.readInt();
            String rankName = buffer.m_130277_();
            ClubPermissionLevel level = (ClubPermissionLevel)buffer.m_130066_(ClubPermissionLevel.class);
            boolean defaultRank = buffer.readBoolean();
            ClubRankInfo item = new ClubRankInfo(rankId, rankName, level, defaultRank);
            ranks.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        ClubRankPage page = new ClubRankPage((List<ClubRankInfo>)ranks, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundClubRankPageScreenOpenPacket(clubId, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClubRankPageScreen.showScreen(this.clubId, this.page));
    }
}

