/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.core.quest.QuestCompassEntry;
import com.equestricraft.mod.client.hud.QuestCompassHudElement;
import com.equestricraft.mod.coordinate.CoordinateSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundCompassCoordinateAddPacket {
    private final QuestCompassEntry entry;

    public ClientBoundCompassCoordinateAddPacket(QuestCompassEntry entry) {
        this.entry = entry;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.entry.uuid());
        CoordinateSerializer.serializeCoordinate(this.entry.coordinates(), buffer);
        buffer.writeBoolean(this.entry.invert());
    }

    public static ClientBoundCompassCoordinateAddPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        Coordinate coord = CoordinateSerializer.deserializeCoordinate(buffer);
        boolean invert = buffer.readBoolean();
        QuestCompassEntry coordinates = new QuestCompassEntry(uuid, coord, invert);
        return new ClientBoundCompassCoordinateAddPacket(coordinates);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            if (this.entry != null) {
                QuestCompassHudElement.addCoordinates(this.entry);
            } else {
                QuestCompassHudElement.clear();
            }
        });
    }
}

