/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.hud.QuestCompassHudElement;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundCompassCoordinateRemovePacket {
    private final UUID uuid;

    public ClientBoundCompassCoordinateRemovePacket(UUID uuid) {
        this.uuid = uuid;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.uuid != null) {
            buffer.writeBoolean(true);
            buffer.m_130077_(this.uuid);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundCompassCoordinateRemovePacket decode(FriendlyByteBuf buffer) {
        UUID identifier = buffer.readBoolean() ? buffer.m_130259_() : null;
        return new ClientBoundCompassCoordinateRemovePacket(identifier);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            if (this.uuid != null) {
                QuestCompassHudElement.removeCoordinates(this.uuid);
            } else {
                QuestCompassHudElement.clear();
            }
        });
    }
}

