/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.compendium.CompendiumGroup;
import com.equestricraft.mod.client.gui.compendium.CompendiumMainMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundCompendiumMainMenuOpenPacket {
    private final List<CompendiumGroup> compendiumGroups;

    public ClientBoundCompendiumMainMenuOpenPacket(List<CompendiumGroup> compendiumGroups) {
        this.compendiumGroups = compendiumGroups;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.compendiumGroups.size());
        for (CompendiumGroup group : this.compendiumGroups) {
            buffer.m_130070_(group.identifier());
            buffer.m_130070_(group.label());
        }
    }

    public static ClientBoundCompendiumMainMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<CompendiumGroup> groups2 = new ArrayList<CompendiumGroup>(amount);
        for (int i = 0; i < amount; ++i) {
            String identifier = buffer.m_130277_();
            String label = buffer.m_130277_();
            CompendiumGroup group = new CompendiumGroup(identifier, label);
            groups2.add(group);
        }
        return new ClientBoundCompendiumMainMenuOpenPacket(groups2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> CompendiumMainMenuScreen.showCompendiumMenu(this.compendiumGroups));
    }
}

