/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.compendium.CompendiumGroupDetail;
import com.equestricraft.core.compendium.CompendiumItem;
import com.equestricraft.mod.client.gui.compendium.CompendiumMenuItemScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundCompendiumMenuOpenPacket {
    private final CompendiumGroupDetail compendiumGroupDetail;

    public ClientBoundCompendiumMenuOpenPacket(CompendiumGroupDetail compendiumGroupDetail) {
        this.compendiumGroupDetail = compendiumGroupDetail;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.compendiumGroupDetail.identifier());
        buffer.m_130070_(this.compendiumGroupDetail.name());
        buffer.writeInt(this.compendiumGroupDetail.items().size());
        for (CompendiumItem item : this.compendiumGroupDetail.items()) {
            buffer.m_130070_(item.getTitle());
            buffer.m_130070_(item.getDescription());
            if (item.getUnlockDate() != null) {
                buffer.writeBoolean(true);
                buffer.m_130075_(item.getUnlockDate());
                continue;
            }
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundCompendiumMenuOpenPacket decode(FriendlyByteBuf buffer) {
        String identifier = buffer.m_130277_();
        String label = buffer.m_130277_();
        int size = buffer.readInt();
        ArrayList<CompendiumItem> items = new ArrayList<CompendiumItem>(size);
        for (int i = 0; i < size; ++i) {
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            Date unlockDate = null;
            boolean unlocked = buffer.readBoolean();
            if (unlocked) {
                unlockDate = buffer.m_130282_();
            }
            items.add(new CompendiumItem(name, description, unlockDate));
        }
        CompendiumGroupDetail group = new CompendiumGroupDetail(identifier, label, items);
        return new ClientBoundCompendiumMenuOpenPacket(group);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> CompendiumMenuItemScreen.showScreen(this.compendiumGroupDetail));
    }
}

