/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.mod.client.gui.horse.dead.DeadHorseSelectPromptScreen;
import com.equestricraft.mod.horse.dead.DeadHorseListItem;
import com.equestricraft.mod.horse.dead.DeadHorseListPage;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundDeadHorseSelectPromptOpenPacket {
    private final UUID uuid;
    private final DeadHorseListPage page;

    public ClientBoundDeadHorseSelectPromptOpenPacket(UUID uuid, DeadHorseListPage page) {
        this.uuid = uuid;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.writeInt(this.page.getItems().size());
        for (DeadHorseListItem item : this.page.getItems()) {
            buffer.writeInt(item.id());
            buffer.m_130070_(item.name());
            if (item.showName() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(item.showName());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeInt(item.daysSinceDeath());
            buffer.writeBoolean(item.deathRegistered());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.m_130070_((String)this.page.getFilterObject());
    }

    public static ClientBoundDeadHorseSelectPromptOpenPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        int itemsCount = buffer.readInt();
        ArrayList<DeadHorseListItem> items = new ArrayList<DeadHorseListItem>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
            int daysSinceDeath = buffer.readInt();
            boolean deathCertificateIssued = buffer.readBoolean();
            DeadHorseListItem item = new DeadHorseListItem(id, name, showName, daysSinceDeath, deathCertificateIssued);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        String filterObject = buffer.m_130277_();
        DeadHorseListPage page = new DeadHorseListPage((List<DeadHorseListItem>)items, pageNumber, totalPages, sortDirection, (Object)null, filterObject);
        return new ClientBoundDeadHorseSelectPromptOpenPacket(uuid, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> DeadHorseSelectPromptScreen.showScreen(this.uuid, this.page));
    }
}

