/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.util.ComponentUtil;
import com.equestricraft.mod.util.TextItemUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundECChatPacket {
    private final UUID playerUuid;
    private final TextItem message;

    public ClientBoundECChatPacket(UUID playerUuid, TextItem message) {
        this.playerUuid = playerUuid;
        this.message = message;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.playerUuid);
        TextItemUtil.encode(buffer, this.message);
    }

    public static ClientBoundECChatPacket decode(FriendlyByteBuf buffer) {
        UUID playerUuid = buffer.m_130259_();
        TextItem message = TextItemUtil.decode(buffer);
        return new ClientBoundECChatPacket(playerUuid, message);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
            if (clientPlayer != null) {
                PlayerSocialManager socialManager = Minecraft.m_91087_().m_91266_();
                if (socialManager.m_100688_(this.playerUuid) || socialManager.m_100686_(this.playerUuid)) {
                    return;
                }
                TextComponent component = ComponentUtil.buildComponentFromTextItem(this.message);
                clientPlayer.m_6352_((Component)component, clientPlayer.m_142081_());
            }
        });
    }
}

